/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.BaseRepositoryTest;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.discovery.DataSetLineageService;
import org.apache.atlas.discovery.DiscoveryService;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.SchemaNotFoundException;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.lang.RandomStringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class DataSetLineageServiceTest
extends BaseRepositoryTest {
    @Inject
    private DiscoveryService discoveryService;
    @Inject
    private DataSetLineageService lineageService;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @DataProvider(name="dslQueriesProvider")
    private Object[][] createDSLQueries() {
        return new String[][]{{"hive_table where name=\"sales_fact\", columns"}, {"hive_table where name=\"sales_fact\", columns select name, dataType, comment"}, {"hive_table where name=\"sales_fact\", columns as c select c.name, c.dataType, c.comment"}, {"from hive_db"}, {"hive_db"}, {"hive_db where hive_db.name=\"Reporting\""}, {"hive_db hive_db.name = \"Reporting\""}, {"hive_db where hive_db.name=\"Reporting\" select name, owner"}, {"hive_db has name"}, {"from hive_table"}, {"hive_table"}, {"hive_table is Dimension"}, {"hive_column where hive_column isa PII"}, {"hive_column select hive_column.name"}, {"hive_column select name"}, {"hive_column where hive_column.name=\"customer_id\""}, {"from hive_table select hive_table.name"}, {"hive_db where (name = \"Reporting\")"}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1"}, {"hive_db where hive_db has name"}, {"hive_db where hive_db has name"}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 "}, {"Dimension"}, {"Fact"}, {"ETL"}, {"Metric"}, {"PII"}};
    }

    @Test(dataProvider="dslQueriesProvider")
    public void testSearchByDSLQueries(String dslQuery) throws Exception {
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.discoveryService.searchByDSL(dslQuery, new QueryParams(100, 0));
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertNotNull((Object)typeName);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertTrue((rows.length() >= 0 ? 1 : 0) != 0);
        System.out.println("query [" + dslQuery + "] returned [" + rows.length() + "] rows");
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetInputsGraphInvalidArguments(final String tableName, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getInputsGraph(tableName);
            }
        });
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetInputsGraphForEntityInvalidArguments(final String tableName, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getInputsGraph(tableName);
            }
        });
    }

    @Test
    public void testGetInputsGraph() throws Exception {
        JSONObject results = this.getInputsGraph("sales_fact_monthly_mv");
        Assert.assertNotNull((Object)results);
        System.out.println("inputs graph = " + results);
        JSONObject values = results.getJSONObject("values");
        Assert.assertNotNull((Object)values);
        JSONObject vertices = values.getJSONObject("vertices");
        Assert.assertEquals((int)vertices.length(), (int)4);
        JSONObject edges = values.getJSONObject("edges");
        Assert.assertEquals((int)edges.length(), (int)4);
    }

    @Test
    public void testCircularLineage() throws Exception {
        JSONObject results = this.getInputsGraph("table2");
        Assert.assertNotNull((Object)results);
        System.out.println("inputs graph = " + results);
        JSONObject values = results.getJSONObject("values");
        Assert.assertNotNull((Object)values);
        JSONObject vertices = values.getJSONObject("vertices");
        Assert.assertEquals((int)vertices.length(), (int)2);
        JSONObject edges = values.getJSONObject("edges");
        Assert.assertEquals((int)edges.length(), (int)4);
    }

    @Test
    public void testGetInputsGraphForEntity() throws Exception {
        ITypedReferenceableInstance entity = this.repository.getEntityDefinition("hive_table", "name", (Object)"sales_fact_monthly_mv");
        JSONObject results = new JSONObject(this.lineageService.getInputsGraphForEntity(entity.getId()._getId()));
        Assert.assertNotNull((Object)results);
        System.out.println("inputs graph = " + results);
        JSONObject values = results.getJSONObject("values");
        Assert.assertNotNull((Object)values);
        JSONObject vertices = values.getJSONObject("vertices");
        Assert.assertEquals((int)vertices.length(), (int)4);
        JSONObject edges = values.getJSONObject("edges");
        Assert.assertEquals((int)edges.length(), (int)4);
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetOutputsGraphInvalidArguments(final String tableName, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getOutputsGraph(tableName);
            }
        });
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetOutputsGraphForEntityInvalidArguments(final String tableId, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getOutputsGraphForEntity(tableId);
            }
        });
    }

    @Test
    public void testGetOutputsGraph() throws Exception {
        JSONObject results = this.getOutputsGraph("sales_fact");
        Assert.assertNotNull((Object)results);
        System.out.println("outputs graph = " + results);
        JSONObject values = results.getJSONObject("values");
        Assert.assertNotNull((Object)values);
        JSONObject vertices = values.getJSONObject("vertices");
        Assert.assertEquals((int)vertices.length(), (int)3);
        JSONObject edges = values.getJSONObject("edges");
        Assert.assertEquals((int)edges.length(), (int)4);
    }

    @Test
    public void testGetOutputsGraphForEntity() throws Exception {
        ITypedReferenceableInstance entity = this.repository.getEntityDefinition("hive_table", "name", (Object)"sales_fact");
        JSONObject results = new JSONObject(this.lineageService.getOutputsGraphForEntity(entity.getId()._getId()));
        Assert.assertNotNull((Object)results);
        System.out.println("outputs graph = " + results);
        JSONObject values = results.getJSONObject("values");
        Assert.assertNotNull((Object)values);
        JSONObject vertices = values.getJSONObject("vertices");
        Assert.assertEquals((int)vertices.length(), (int)3);
        JSONObject edges = values.getJSONObject("edges");
        Assert.assertEquals((int)edges.length(), (int)4);
    }

    @DataProvider(name="tableNamesProvider")
    private Object[][] tableNames() {
        return new String[][]{{"sales_fact", "4"}, {"time_dim", "3"}, {"sales_fact_daily_mv", "4"}, {"sales_fact_monthly_mv", "4"}};
    }

    @Test(dataProvider="tableNamesProvider")
    public void testGetSchema(String tableName, String expected) throws Exception {
        JSONObject results = this.getSchema(tableName);
        Assert.assertNotNull((Object)results);
        System.out.println("columns = " + results);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertEquals((int)rows.length(), (int)Integer.parseInt(expected));
        for (int index = 0; index < rows.length(); ++index) {
            this.assertColumn(rows.getJSONObject(index));
        }
    }

    @Test(dataProvider="tableNamesProvider")
    public void testGetSchemaForEntity(String tableName, String expected) throws Exception {
        ITypedReferenceableInstance entity = this.repository.getEntityDefinition("hive_table", "name", (Object)tableName);
        JSONObject results = new JSONObject(this.lineageService.getSchemaForEntity(entity.getId()._getId()));
        Assert.assertNotNull((Object)results);
        System.out.println("columns = " + results);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertEquals((int)rows.length(), (int)Integer.parseInt(expected));
        for (int index = 0; index < rows.length(); ++index) {
            this.assertColumn(rows.getJSONObject(index));
        }
    }

    private void assertColumn(JSONObject jsonObject) throws JSONException {
        Assert.assertNotNull((Object)jsonObject.getString("name"));
        Assert.assertNotNull((Object)jsonObject.getString("comment"));
        Assert.assertNotNull((Object)jsonObject.getString("dataType"));
        Assert.assertEquals((String)jsonObject.getString("$typeName$"), (String)"hive_column");
    }

    @Test(expectedExceptions={SchemaNotFoundException.class})
    public void testGetSchemaForDBEntity() throws Exception {
        String dbId = this.getEntityId("dataset_subtype", "name", "dataSetSubTypeInst1");
        JSONObject results = new JSONObject(this.lineageService.getSchemaForEntity(dbId));
    }

    @DataProvider(name="invalidArgumentsProvider")
    private Object[][] arguments() {
        return new String[][]{{null, IllegalArgumentException.class.getName()}, {"", IllegalArgumentException.class.getName()}, {"blah", EntityNotFoundException.class.getName()}};
    }

    public void testInvalidArguments(String expectedException, Invoker invoker) throws Exception {
        try {
            invoker.run();
            Assert.fail((String)("Expected " + expectedException));
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getClass().getName(), (String)expectedException);
        }
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetSchemaInvalidArguments(final String tableName, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getSchema(tableName);
            }
        });
    }

    @Test(dataProvider="invalidArgumentsProvider")
    public void testGetSchemaForEntityInvalidArguments(final String entityId, String expectedException) throws Exception {
        this.testInvalidArguments(expectedException, new Invoker(){

            @Override
            void run() throws AtlasException {
                DataSetLineageServiceTest.this.lineageService.getSchemaForEntity(entityId);
            }
        });
    }

    private JSONObject getSchema(String tableName) throws Exception {
        return new JSONObject(this.lineageService.getSchema("qualified:" + tableName));
    }

    private JSONObject getInputsGraph(String tableName) throws Exception {
        return new JSONObject(this.lineageService.getInputsGraph("qualified:" + tableName));
    }

    private JSONObject getOutputsGraph(String tableName) throws Exception {
        return new JSONObject(this.lineageService.getOutputsGraph("qualified:" + tableName));
    }

    @Test
    public void testLineageWithDelete() throws Exception {
        String tableName = "table" + this.random();
        this.createTable(tableName, 3, true);
        String tableId = this.getEntityId("hive_table", "name", tableName);
        JSONObject results = this.getSchema(tableName);
        Assert.assertEquals((int)results.getJSONArray("rows").length(), (int)3);
        results = this.getInputsGraph(tableName);
        Struct resultInstance = InstanceSerialization.fromJsonStruct((String)results.toString(), (boolean)true);
        Map vertices = (Map)resultInstance.get("vertices");
        Assert.assertEquals((int)vertices.size(), (int)2);
        Struct vertex = (Struct)vertices.get(tableId);
        Assert.assertEquals((Object)((Struct)vertex.get("vertexId")).get("state"), (Object)Id.EntityState.ACTIVE.name());
        results = this.getOutputsGraph(tableName);
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)2);
        results = new JSONObject(this.lineageService.getSchemaForEntity(tableId));
        Assert.assertEquals((int)results.getJSONArray("rows").length(), (int)3);
        results = new JSONObject(this.lineageService.getInputsGraphForEntity(tableId));
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)2);
        results = new JSONObject(this.lineageService.getOutputsGraphForEntity(tableId));
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)2);
        AtlasClient.EntityResult deleteResult = this.repository.deleteEntities(Arrays.asList(tableId));
        Assert.assertTrue((boolean)deleteResult.getDeletedEntities().contains(tableId));
        results = new JSONObject(this.lineageService.getSchemaForEntity(tableId));
        Assert.assertEquals((int)results.getJSONArray("rows").length(), (int)3);
        results = new JSONObject(this.lineageService.getInputsGraphForEntity(tableId));
        resultInstance = InstanceSerialization.fromJsonStruct((String)results.toString(), (boolean)true);
        vertices = (Map)resultInstance.get("vertices");
        Assert.assertEquals((int)vertices.size(), (int)2);
        vertex = (Struct)vertices.get(tableId);
        Assert.assertEquals((Object)((Struct)vertex.get("vertexId")).get("state"), (Object)Id.EntityState.DELETED.name());
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)2);
        results = new JSONObject(this.lineageService.getOutputsGraphForEntity(tableId));
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)2);
        try {
            this.getSchema(tableName);
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        try {
            this.getInputsGraph(tableName);
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        try {
            this.getOutputsGraph(tableName);
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        this.createTable(tableName, 2, false);
        results = this.getSchema(tableName);
        Assert.assertEquals((int)results.getJSONArray("rows").length(), (int)2);
        results = this.getOutputsGraph(tableName);
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)0);
        results = this.getInputsGraph(tableName);
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)0);
        tableId = this.getEntityId("hive_table", "name", tableName);
        results = new JSONObject(this.lineageService.getSchemaForEntity(tableId));
        Assert.assertEquals((int)results.getJSONArray("rows").length(), (int)2);
        results = new JSONObject(this.lineageService.getInputsGraphForEntity(tableId));
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)0);
        results = new JSONObject(this.lineageService.getOutputsGraphForEntity(tableId));
        Assert.assertEquals((int)results.getJSONObject("values").getJSONObject("vertices").length(), (int)0);
    }

    private void createTable(String tableName, int numCols, boolean createLineage) throws Exception {
        String dbId = this.getEntityId("hive_db", "name", "Sales");
        Id salesDB = new Id(dbId, 0, "hive_db");
        ArrayStack columns = new ArrayStack();
        for (int i = 0; i < numCols; ++i) {
            columns.add(this.column("col" + this.random(), "int", "column descr", new String[0]));
        }
        Referenceable sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<Referenceable>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        Id table = this.table(tableName, "test table", salesDB, sd, "fetl", "External", (List<Referenceable>)columns, new String[0]);
        if (createLineage) {
            Id inTable = this.table("table" + this.random(), "test table", salesDB, sd, "fetl", "External", (List<Referenceable>)columns, new String[0]);
            Id outTable = this.table("table" + this.random(), "test table", salesDB, sd, "fetl", "External", (List<Referenceable>)columns, new String[0]);
            this.loadProcess("process" + this.random(), "hive query for monthly summary", "Tim ETL", (List<Id>)ImmutableList.of((Object)inTable), (List<Id>)ImmutableList.of((Object)table), "create table as select ", "plan", "id", "graph", "ETL");
            this.loadProcess("process" + this.random(), "hive query for monthly summary", "Tim ETL", (List<Id>)ImmutableList.of((Object)table), (List<Id>)ImmutableList.of((Object)outTable), "create table as select ", "plan", "id", "graph", "ETL");
        }
    }

    private String random() {
        return RandomStringUtils.randomAlphanumeric((int)5);
    }

    private String getEntityId(String typeName, String attributeName, String attributeValue) throws Exception {
        return this.repository.getEntityDefinition(typeName, attributeName, (Object)attributeValue).getId()._getId();
    }

    abstract class Invoker {
        Invoker() {
        }

        abstract void run() throws AtlasException;
    }
}

