/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.EnumTypeDefinition;
import org.apache.atlas.typesystem.types.EnumValue;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.StructTypeDefinition;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.testng.Assert;

public final class TestUtils {
    public static final long TEST_DATE_IN_LONG = 1418265358440L;
    public static final String DEPARTMENT_TYPE = "Department";
    public static final String PERSON_TYPE = "Person";
    public static final String DATABASE_TYPE = "hive_database";
    public static final String DATABASE_NAME = "foo";
    public static final String TABLE_TYPE = "hive_table";
    public static final String PROCESS_TYPE = "hive_process";
    public static final String COLUMN_TYPE = "column_type";
    public static final String TABLE_NAME = "bar";
    public static final String CLASSIFICATION = "classification";
    public static final String PII = "PII";
    public static final String SUPER_TYPE_NAME = "Base";
    public static final String STORAGE_DESC_TYPE = "hive_storagedesc";
    public static final String PARTITION_STRUCT_TYPE = "partition_struct_type";
    public static final String PARTITION_CLASS_TYPE = "partition_class_type";
    public static final String SERDE_TYPE = "serdeType";
    public static final String COLUMNS_MAP = "columnsMap";
    public static final String COLUMNS_ATTR_NAME = "columns";
    public static final String NAME = "name";

    private TestUtils() {
    }

    public static String dumpGraph(TitanGraph titanGraph) throws Exception {
        File tempFile = File.createTempFile("graph", ".gson");
        System.out.println("tempFile.getPath() = " + tempFile.getPath());
        GraphSONWriter.outputGraph((Graph)titanGraph, (String)tempFile.getPath());
        GraphHelper.dumpToLog((Graph)titanGraph);
        return tempFile.getPath();
    }

    public static void defineDeptEmployeeTypes(TypeSystem ts) throws AtlasException {
        String _description = "_description";
        EnumTypeDefinition orgLevelEnum = new EnumTypeDefinition("OrgLevel", "OrgLevel" + _description, new EnumValue[]{new EnumValue("L1", 1), new EnumValue("L2", 2)});
        StructTypeDefinition addressDetails = TypesUtil.createStructTypeDef((String)"Address", (String)("Address" + _description), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"street", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"city", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition deptTypeDef = TypesUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)(DEPARTMENT_TYPE + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), new AttributeDefinition("employees", String.format("array<%s>", PERSON_TYPE), Multiplicity.OPTIONAL, true, "department")});
        HierarchicalTypeDefinition personTypeDef = TypesUtil.createClassTypeDef((String)PERSON_TYPE, (String)(PERSON_TYPE + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"orgLevel", (String)"OrgLevel"), TypesUtil.createOptionalAttrDef((String)"address", (String)"Address"), new AttributeDefinition("department", DEPARTMENT_TYPE, Multiplicity.REQUIRED, false, "employees"), new AttributeDefinition("manager", "Manager", Multiplicity.OPTIONAL, false, "subordinates"), new AttributeDefinition("mentor", PERSON_TYPE, Multiplicity.OPTIONAL, false, null), TypesUtil.createOptionalAttrDef((String)"birthday", (IDataType)DataTypes.DATE_TYPE), TypesUtil.createOptionalAttrDef((String)"hasPets", (IDataType)DataTypes.BOOLEAN_TYPE), TypesUtil.createOptionalAttrDef((String)"numberOfCars", (IDataType)DataTypes.BYTE_TYPE), TypesUtil.createOptionalAttrDef((String)"houseNumber", (IDataType)DataTypes.SHORT_TYPE), TypesUtil.createOptionalAttrDef((String)"carMileage", (IDataType)DataTypes.INT_TYPE), TypesUtil.createOptionalAttrDef((String)"shares", (IDataType)DataTypes.LONG_TYPE), TypesUtil.createOptionalAttrDef((String)"salary", (IDataType)DataTypes.DOUBLE_TYPE), TypesUtil.createOptionalAttrDef((String)"age", (IDataType)DataTypes.FLOAT_TYPE), TypesUtil.createOptionalAttrDef((String)"numberOfStarsEstimate", (IDataType)DataTypes.BIGINTEGER_TYPE), TypesUtil.createOptionalAttrDef((String)"approximationOfPi", (IDataType)DataTypes.BIGDECIMAL_TYPE)});
        HierarchicalTypeDefinition managerTypeDef = TypesUtil.createClassTypeDef((String)"Manager", (String)("Manager" + _description), (ImmutableSet)ImmutableSet.of((Object)PERSON_TYPE), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("subordinates", String.format("array<%s>", PERSON_TYPE), Multiplicity.COLLECTION, false, "manager")});
        HierarchicalTypeDefinition securityClearanceTypeDef = TypesUtil.createTraitTypeDef((String)"SecurityClearance", (String)("SecurityClearance" + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"level", (IDataType)DataTypes.INT_TYPE)});
        ts.defineTypes(ImmutableList.of((Object)orgLevelEnum), ImmutableList.of((Object)addressDetails), ImmutableList.of((Object)securityClearanceTypeDef), ImmutableList.of((Object)deptTypeDef, (Object)personTypeDef, (Object)managerTypeDef));
    }

    public static ITypedReferenceableInstance createDeptEg1(TypeSystem ts) throws AtlasException {
        Referenceable hrDept = new Referenceable(DEPARTMENT_TYPE, new String[0]);
        Referenceable john = new Referenceable(PERSON_TYPE, new String[0]);
        Referenceable jane = new Referenceable("Manager", new String[]{"SecurityClearance"});
        Referenceable johnAddr = new Referenceable("Address", new String[0]);
        Referenceable janeAddr = new Referenceable("Address", new String[0]);
        Referenceable julius = new Referenceable("Manager", new String[0]);
        Referenceable juliusAddr = new Referenceable("Address", new String[0]);
        Referenceable max = new Referenceable(PERSON_TYPE, new String[0]);
        Referenceable maxAddr = new Referenceable("Address", new String[0]);
        hrDept.set(NAME, (Object)"hr");
        john.set(NAME, (Object)"John");
        john.set("department", (Object)hrDept);
        johnAddr.set("street", (Object)"Stewart Drive");
        johnAddr.set("city", (Object)"Sunnyvale");
        john.set("address", (Object)johnAddr);
        john.set("birthday", (Object)new Date(1950, 5, 15));
        john.set("hasPets", (Object)true);
        john.set("numberOfCars", (Object)1);
        john.set("houseNumber", (Object)153);
        john.set("carMileage", (Object)13364);
        john.set("shares", (Object)15000);
        john.set("salary", (Object)123345.678);
        john.set("age", (Object)50);
        john.set("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000"));
        john.set("approximationOfPi", (Object)new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286"));
        jane.set(NAME, (Object)"Jane");
        jane.set("department", (Object)hrDept);
        janeAddr.set("street", (Object)"Great America Parkway");
        janeAddr.set("city", (Object)"Santa Clara");
        jane.set("address", (Object)janeAddr);
        janeAddr.set("street", (Object)"Great America Parkway");
        julius.set(NAME, (Object)"Julius");
        julius.set("department", (Object)hrDept);
        juliusAddr.set("street", (Object)"Madison Ave");
        juliusAddr.set("city", (Object)"Newtonville");
        julius.set("address", (Object)juliusAddr);
        julius.set("subordinates", (Object)ImmutableList.of());
        max.set(NAME, (Object)"Max");
        max.set("department", (Object)hrDept);
        maxAddr.set("street", (Object)"Ripley St");
        maxAddr.set("city", (Object)"Newton");
        max.set("address", (Object)maxAddr);
        max.set("manager", (Object)jane);
        max.set("mentor", (Object)julius);
        max.set("birthday", (Object)new Date(1979, 3, 15));
        max.set("hasPets", (Object)true);
        max.set("age", (Object)36);
        max.set("numberOfCars", (Object)2);
        max.set("houseNumber", (Object)17);
        max.set("carMileage", (Object)13);
        max.set("shares", (Object)Long.MAX_VALUE);
        max.set("salary", (Object)Double.MAX_VALUE);
        max.set("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000000000000"));
        max.set("approximationOfPi", (Object)new BigDecimal("3.1415926535897932"));
        john.set("manager", (Object)jane);
        john.set("mentor", (Object)max);
        hrDept.set("employees", (Object)ImmutableList.of((Object)john, (Object)jane, (Object)julius, (Object)max));
        jane.set("subordinates", (Object)ImmutableList.of((Object)john, (Object)max));
        jane.getTrait("SecurityClearance").set("level", (Object)1);
        ClassType deptType = (ClassType)ts.getDataType(ClassType.class, DEPARTMENT_TYPE);
        ITypedReferenceableInstance hrDept2 = deptType.convert((Object)hrDept, Multiplicity.REQUIRED);
        Assert.assertNotNull((Object)hrDept2);
        return hrDept2;
    }

    public static TypesDef defineHiveTypes() {
        String _description = "_description";
        HierarchicalTypeDefinition superTypeDefinition = TypesUtil.createClassTypeDef((String)SUPER_TYPE_NAME, (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"namespace", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"cluster", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"colo", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition databaseTypeDefinition = TypesUtil.createClassTypeDef((String)DATABASE_TYPE, (String)(DATABASE_TYPE + _description), (ImmutableSet)ImmutableSet.of((Object)SUPER_TYPE_NAME), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"created", (IDataType)DataTypes.DATE_TYPE), TypesUtil.createOptionalAttrDef((String)"isReplicated", (IDataType)DataTypes.BOOLEAN_TYPE), new AttributeDefinition("parameters", new DataTypes.MapType((IDataType)DataTypes.STRING_TYPE, (IDataType)DataTypes.STRING_TYPE).getName(), Multiplicity.OPTIONAL, false, null), TypesUtil.createRequiredAttrDef((String)"description", (IDataType)DataTypes.STRING_TYPE)});
        StructTypeDefinition structTypeDefinition = new StructTypeDefinition(SERDE_TYPE, SERDE_TYPE + _description, new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"serde", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"description", (IDataType)DataTypes.STRING_TYPE)});
        EnumValue[] values = new EnumValue[]{new EnumValue("MANAGED", 1), new EnumValue("EXTERNAL", 2)};
        EnumTypeDefinition enumTypeDefinition = new EnumTypeDefinition("tableType", "tableType" + _description, values);
        HierarchicalTypeDefinition columnsDefinition = TypesUtil.createClassTypeDef((String)COLUMN_TYPE, (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"type", (IDataType)DataTypes.STRING_TYPE)});
        StructTypeDefinition partitionDefinition = new StructTypeDefinition(PARTITION_STRUCT_TYPE, PARTITION_STRUCT_TYPE + _description, new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE)});
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("location", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("inputFormat", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("outputFormat", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("compressed", DataTypes.BOOLEAN_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("numBuckets", DataTypes.INT_TYPE.getName(), Multiplicity.OPTIONAL, false, null)};
        HierarchicalTypeDefinition storageDescClsDef = new HierarchicalTypeDefinition(ClassType.class, STORAGE_DESC_TYPE, STORAGE_DESC_TYPE + _description, ImmutableSet.of((Object)SUPER_TYPE_NAME), attributeDefinitions);
        AttributeDefinition[] partClsAttributes = new AttributeDefinition[]{new AttributeDefinition("values", DataTypes.arrayTypeName((String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("table", TABLE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("createTime", DataTypes.LONG_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("lastAccessTime", DataTypes.LONG_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("sd", STORAGE_DESC_TYPE, Multiplicity.REQUIRED, true, null), new AttributeDefinition(COLUMNS_ATTR_NAME, DataTypes.arrayTypeName((String)COLUMN_TYPE), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("parameters", new DataTypes.MapType((IDataType)DataTypes.STRING_TYPE, (IDataType)DataTypes.STRING_TYPE).getName(), Multiplicity.OPTIONAL, false, null)};
        HierarchicalTypeDefinition partClsDef = new HierarchicalTypeDefinition(ClassType.class, PARTITION_CLASS_TYPE, PARTITION_CLASS_TYPE + _description, ImmutableSet.of((Object)SUPER_TYPE_NAME), partClsAttributes);
        HierarchicalTypeDefinition processClsType = new HierarchicalTypeDefinition(ClassType.class, PROCESS_TYPE, PROCESS_TYPE + _description, ImmutableSet.of(), new AttributeDefinition[]{new AttributeDefinition("outputs", "array<hive_table>", Multiplicity.OPTIONAL, false, null)});
        HierarchicalTypeDefinition tableTypeDefinition = TypesUtil.createClassTypeDef((String)TABLE_TYPE, (String)(TABLE_TYPE + _description), (ImmutableSet)ImmutableSet.of((Object)SUPER_TYPE_NAME), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)NAME, (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"description", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"type", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"created", (IDataType)DataTypes.DATE_TYPE), new AttributeDefinition("tableType", "tableType", Multiplicity.REQUIRED, false, null), new AttributeDefinition("columnNames", String.format("array<%s>", DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(COLUMNS_ATTR_NAME, String.format("array<%s>", COLUMN_TYPE), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("partitions", String.format("array<%s>", PARTITION_STRUCT_TYPE), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("parametersMap", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, true, null), new AttributeDefinition(COLUMNS_MAP, DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)COLUMN_TYPE), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("partitionsMap", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)PARTITION_STRUCT_TYPE), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("serde1", SERDE_TYPE, Multiplicity.OPTIONAL, false, null), new AttributeDefinition("serde2", SERDE_TYPE, Multiplicity.OPTIONAL, false, null), new AttributeDefinition("database", DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("databaseComposite", DATABASE_TYPE, Multiplicity.OPTIONAL, true, null)});
        HierarchicalTypeDefinition piiTypeDefinition = TypesUtil.createTraitTypeDef((String)PII, (String)(PII + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition classificationTypeDefinition = TypesUtil.createTraitTypeDef((String)CLASSIFICATION, (String)(CLASSIFICATION + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"tag", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition fetlClassificationTypeDefinition = TypesUtil.createTraitTypeDef((String)"fetlclassification", (String)("fetlclassification" + _description), (ImmutableSet)ImmutableSet.of((Object)CLASSIFICATION), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"tag", (IDataType)DataTypes.STRING_TYPE)});
        return TypesUtil.getTypesDef((ImmutableList)ImmutableList.of((Object)enumTypeDefinition), (ImmutableList)ImmutableList.of((Object)structTypeDefinition, (Object)partitionDefinition), (ImmutableList)ImmutableList.of((Object)classificationTypeDefinition, (Object)fetlClassificationTypeDefinition, (Object)piiTypeDefinition), (ImmutableList)ImmutableList.of((Object)superTypeDefinition, (Object)databaseTypeDefinition, (Object)columnsDefinition, (Object)tableTypeDefinition, (Object)storageDescClsDef, (Object)partClsDef, (Object)processClsType));
    }

    public static Collection<IDataType> createHiveTypes(TypeSystem typeSystem) throws Exception {
        if (!typeSystem.isRegistered(TABLE_TYPE)) {
            TypesDef typesDef = TestUtils.defineHiveTypes();
            return typeSystem.defineTypes(typesDef).values();
        }
        return new ArrayList<IDataType>();
    }

    public static final String randomString() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    public static Referenceable createDBEntity() {
        Referenceable entity = new Referenceable(DATABASE_TYPE, new String[0]);
        String dbName = RandomStringUtils.randomAlphanumeric((int)10);
        entity.set(NAME, (Object)dbName);
        entity.set("description", (Object)"us db");
        return entity;
    }

    public static Referenceable createTableEntity(String dbId) {
        Referenceable entity = new Referenceable(TABLE_TYPE, new String[0]);
        String tableName = RandomStringUtils.randomAlphanumeric((int)10);
        entity.set(NAME, (Object)tableName);
        entity.set("description", (Object)"random table");
        entity.set("type", (Object)"type");
        entity.set("tableType", (Object)"MANAGED");
        entity.set("database", (Object)new Id(dbId, 0, DATABASE_TYPE));
        entity.set("created", (Object)new Date());
        return entity;
    }

    public static Referenceable createColumnEntity() {
        Referenceable entity = new Referenceable(COLUMN_TYPE, new String[0]);
        entity.set(NAME, (Object)RandomStringUtils.randomAlphanumeric((int)10));
        entity.set("type", (Object)"VARCHAR(32)");
        return entity;
    }

    public static String createInstance(MetadataService metadataService, Referenceable entity) throws Exception {
        RequestContext.createContext();
        String entityjson = InstanceSerialization.toJson((IStruct)entity, (boolean)true);
        JSONArray entitiesJson = new JSONArray();
        entitiesJson.put((Object)entityjson);
        List guids = metadataService.createEntities(entitiesJson.toString());
        if (guids != null && guids.size() > 0) {
            return (String)guids.get(guids.size() - 1);
        }
        return null;
    }
}

