/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.MetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.testng.annotations.Guice;

@Guice(modules={RepositoryMetadataModule.class})
public class BaseRepositoryTest {
    @Inject
    protected MetadataService metadataService;
    @Inject
    protected MetadataRepository repository;
    @Inject
    protected GraphProvider<TitanGraph> graphProvider;
    protected static final String DATABASE_TYPE = "hive_db";
    protected static final String HIVE_TABLE_TYPE = "hive_table";
    private static final String COLUMN_TYPE = "hive_column";
    private static final String HIVE_PROCESS_TYPE = "hive_process";
    private static final String STORAGE_DESC_TYPE = "StorageDesc";
    private static final String VIEW_TYPE = "View";
    private static final String PARTITION_TYPE = "hive_partition";
    protected static final String DATASET_SUBTYPE = "dataset_subtype";

    protected void setUp() throws Exception {
        this.setUpTypes();
        new GraphBackedSearchIndexer(this.graphProvider);
        RequestContext.createContext();
        this.setupInstances();
        TestUtils.dumpGraph((TitanGraph)this.graphProvider.get());
    }

    protected void tearDown() throws Exception {
        TypeSystem.getInstance().reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpTypes() throws Exception {
        TypesDef typesDef = this.createTypeDefinitions();
        String typesAsJSON = TypesSerialization.toJson((TypesDef)typesDef);
        this.metadataService.createType(typesAsJSON);
    }

    TypesDef createTypeDefinitions() {
        HierarchicalTypeDefinition dbClsDef = TypesUtil.createClassTypeDef((String)DATABASE_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE), this.attrDef("description", (IDataType)DataTypes.STRING_TYPE), this.attrDef("locationUri", (IDataType)DataTypes.STRING_TYPE), this.attrDef("owner", (IDataType)DataTypes.STRING_TYPE), this.attrDef("createTime", (IDataType)DataTypes.LONG_TYPE)});
        HierarchicalTypeDefinition columnClsDef = TypesUtil.createClassTypeDef((String)COLUMN_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", (IDataType)DataTypes.STRING_TYPE), this.attrDef("dataType", (IDataType)DataTypes.STRING_TYPE), this.attrDef("comment", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition storageDescClsDef = TypesUtil.createClassTypeDef((String)STORAGE_DESC_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("location", (IDataType)DataTypes.STRING_TYPE), this.attrDef("inputFormat", (IDataType)DataTypes.STRING_TYPE), this.attrDef("outputFormat", (IDataType)DataTypes.STRING_TYPE), this.attrDef("compressed", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED, false, null)});
        HierarchicalTypeDefinition tblClsDef = TypesUtil.createClassTypeDef((String)HIVE_TABLE_TYPE, (ImmutableSet)ImmutableSet.of((Object)"DataSet"), (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("owner", (IDataType)DataTypes.STRING_TYPE), this.attrDef("createTime", (IDataType)DataTypes.DATE_TYPE), this.attrDef("lastAccessTime", (IDataType)DataTypes.LONG_TYPE), this.attrDef("tableType", (IDataType)DataTypes.STRING_TYPE), this.attrDef("temporary", (IDataType)DataTypes.BOOLEAN_TYPE), new AttributeDefinition("db", DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("sd", STORAGE_DESC_TYPE, Multiplicity.REQUIRED, true, null), new AttributeDefinition("columns", DataTypes.arrayTypeName((String)COLUMN_TYPE), Multiplicity.COLLECTION, true, null)});
        HierarchicalTypeDefinition loadProcessClsDef = TypesUtil.createClassTypeDef((String)HIVE_PROCESS_TYPE, (ImmutableSet)ImmutableSet.of((Object)"Process"), (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("userName", (IDataType)DataTypes.STRING_TYPE), this.attrDef("startTime", (IDataType)DataTypes.LONG_TYPE), this.attrDef("endTime", (IDataType)DataTypes.LONG_TYPE), this.attrDef("queryText", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryPlan", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryId", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryGraph", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED)});
        HierarchicalTypeDefinition viewClsDef = TypesUtil.createClassTypeDef((String)VIEW_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", (IDataType)DataTypes.STRING_TYPE), new AttributeDefinition("db", DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("inputTables", DataTypes.arrayTypeName((String)HIVE_TABLE_TYPE), Multiplicity.COLLECTION, false, null)});
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("values", DataTypes.arrayTypeName((String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("table", HIVE_TABLE_TYPE, Multiplicity.REQUIRED, false, null)};
        HierarchicalTypeDefinition partClsDef = new HierarchicalTypeDefinition(ClassType.class, PARTITION_TYPE, null, null, attributeDefinitions);
        HierarchicalTypeDefinition datasetSubTypeClsDef = TypesUtil.createClassTypeDef((String)DATASET_SUBTYPE, (ImmutableSet)ImmutableSet.of((Object)"DataSet"), (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition dimTraitDef = TypesUtil.createTraitTypeDef((String)"Dimension", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition factTraitDef = TypesUtil.createTraitTypeDef((String)"Fact", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition metricTraitDef = TypesUtil.createTraitTypeDef((String)"Metric", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition etlTraitDef = TypesUtil.createTraitTypeDef((String)"ETL", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition piiTraitDef = TypesUtil.createTraitTypeDef((String)"PII", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition jdbcTraitDef = TypesUtil.createTraitTypeDef((String)"JdbcAccess", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition logTraitDef = TypesUtil.createTraitTypeDef((String)"Log Data", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition isaKeywordTraitDef = TypesUtil.createTraitTypeDef((String)"isa", null, (AttributeDefinition[])new AttributeDefinition[0]);
        return TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)dimTraitDef, (Object)factTraitDef, (Object)piiTraitDef, (Object)metricTraitDef, (Object)etlTraitDef, (Object)jdbcTraitDef, (Object)logTraitDef, (Object)isaKeywordTraitDef), (ImmutableList)ImmutableList.of((Object)dbClsDef, (Object)storageDescClsDef, (Object)columnClsDef, (Object)tblClsDef, (Object)loadProcessClsDef, (Object)viewClsDef, (Object)partClsDef, (Object)datasetSubTypeClsDef));
    }

    AttributeDefinition attrDef(String name, IDataType dT) {
        return this.attrDef(name, dT, Multiplicity.OPTIONAL, false, null);
    }

    AttributeDefinition attrDef(String name, IDataType dT, Multiplicity m) {
        return this.attrDef(name, dT, m, false, null);
    }

    AttributeDefinition attrDef(String name, IDataType dT, Multiplicity m, boolean isComposite, String reverseAttributeName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)dT);
        return new AttributeDefinition(name, dT.getName(), m, isComposite, reverseAttributeName);
    }

    private void setupInstances() throws Exception {
        Id salesDB = this.database("Sales", "Sales Database", "John ETL", "hdfs://host:8000/apps/warehouse/sales", new String[0]);
        Referenceable sd = this.storageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true, (List<Referenceable>)ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0])));
        ImmutableList salesFactColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("product_id", "int", "product id", new String[0]), (Object)this.column("customer_id", "int", "customer id", "PII"), (Object)this.column("sales", "double", "product id", "Metric"));
        Id salesFact = this.table("sales_fact", "sales fact table", salesDB, sd, "Joe", "Managed", (List<Referenceable>)salesFactColumns, "Fact");
        ImmutableList logFactColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("app_id", "int", "app id", new String[0]), (Object)this.column("machine_id", "int", "machine id", new String[0]), (Object)this.column("log", "string", "log data", "Log Data"));
        ImmutableList timeDimColumns = ImmutableList.of((Object)this.column("time_id", "int", "time id", new String[0]), (Object)this.column("dayOfYear", "int", "day Of Year", new String[0]), (Object)this.column("weekDay", "int", "week Day", new String[0]));
        Id timeDim = this.table("time_dim", "time dimension table", salesDB, sd, "John Doe", "External", (List<Referenceable>)timeDimColumns, "Dimension");
        Id reportingDB = this.database("Reporting", "reporting database", "Jane BI", "hdfs://host:8000/apps/warehouse/reporting", new String[0]);
        Id salesFactDaily = this.table("sales_fact_daily_mv", "sales fact daily materialized view", reportingDB, sd, "Joe BI", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        Id circularLineageTable1 = this.table("table1", "", reportingDB, sd, "Vimal", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        Id circularLineageTable2 = this.table("table2", "", reportingDB, sd, "Vimal", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        this.loadProcess("circularLineage1", "hive query for daily summary", "John ETL", (List<Id>)ImmutableList.of((Object)circularLineageTable1), (List<Id>)ImmutableList.of((Object)circularLineageTable2), "create table as select ", "plan", "id", "graph", "ETL");
        this.loadProcess("circularLineage2", "hive query for daily summary", "John ETL", (List<Id>)ImmutableList.of((Object)circularLineageTable2), (List<Id>)ImmutableList.of((Object)circularLineageTable1), "create table as select ", "plan", "id", "graph", "ETL");
        this.loadProcess("loadSalesDaily", "hive query for daily summary", "John ETL", (List<Id>)ImmutableList.of((Object)salesFact, (Object)timeDim), (List<Id>)ImmutableList.of((Object)salesFactDaily), "create table as select ", "plan", "id", "graph", "ETL");
        Id logDB = this.database("Logging", "logging database", "Tim ETL", "hdfs://host:8000/apps/warehouse/logging", new String[0]);
        Id loggingFactDaily = this.table("log_fact_daily_mv", "log fact daily materialized view", logDB, sd, "Tim ETL", "Managed", (List<Referenceable>)logFactColumns, "Log Data");
        ImmutableList productDimColumns = ImmutableList.of((Object)this.column("product_id", "int", "product id", new String[0]), (Object)this.column("product_name", "string", "product name", new String[0]), (Object)this.column("brand_name", "int", "brand name", new String[0]));
        Id productDim = this.table("product_dim", "product dimension table", salesDB, sd, "John Doe", "Managed", (List<Referenceable>)productDimColumns, "Dimension");
        this.view("product_dim_view", reportingDB, (List<Id>)ImmutableList.of((Object)productDim), "Dimension", "JdbcAccess");
        ImmutableList customerDimColumns = ImmutableList.of((Object)this.column("customer_id", "int", "customer id", "PII"), (Object)this.column("name", "string", "customer name", "PII"), (Object)this.column("address", "string", "customer address", "PII"));
        Id customerDim = this.table("customer_dim", "customer dimension table", salesDB, sd, "fetl", "External", (List<Referenceable>)customerDimColumns, "Dimension");
        this.view("customer_dim_view", reportingDB, (List<Id>)ImmutableList.of((Object)customerDim), "Dimension", "JdbcAccess");
        Id salesFactMonthly = this.table("sales_fact_monthly_mv", "sales fact monthly materialized view", reportingDB, sd, "Jane BI", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        this.loadProcess("loadSalesMonthly", "hive query for monthly summary", "John ETL", (List<Id>)ImmutableList.of((Object)salesFactDaily), (List<Id>)ImmutableList.of((Object)salesFactMonthly), "create table as select ", "plan", "id", "graph", "ETL");
        Id loggingFactMonthly = this.table("logging_fact_monthly_mv", "logging fact monthly materialized view", logDB, sd, "Tim ETL", "Managed", (List<Referenceable>)logFactColumns, "Log Data");
        this.loadProcess("loadLogsMonthly", "hive query for monthly summary", "Tim ETL", (List<Id>)ImmutableList.of((Object)loggingFactDaily), (List<Id>)ImmutableList.of((Object)loggingFactMonthly), "create table as select ", "plan", "id", "graph", "ETL");
        this.partition(new ArrayList(){
            {
                this.add("2015-01-01");
            }
        }, salesFactDaily, new String[0]);
        this.datasetSubType("dataSetSubTypeInst1", "testOwner");
    }

    Id database(String name, String description, String owner, String locationUri, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(DATABASE_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("description", (Object)description);
        referenceable.set("owner", (Object)owner);
        referenceable.set("locationUri", (Object)locationUri);
        referenceable.set("createTime", (Object)System.currentTimeMillis());
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, DATABASE_TYPE);
        return this.createInstance(referenceable, clsType);
    }

    protected Referenceable storageDescriptor(String location, String inputFormat, String outputFormat, boolean compressed, List<Referenceable> columns) throws Exception {
        Referenceable referenceable = new Referenceable(STORAGE_DESC_TYPE, new String[0]);
        referenceable.set("location", (Object)location);
        referenceable.set("inputFormat", (Object)inputFormat);
        referenceable.set("outputFormat", (Object)outputFormat);
        referenceable.set("compressed", (Object)compressed);
        referenceable.set("cols", columns);
        return referenceable;
    }

    protected Referenceable column(String name, String dataType, String comment, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(COLUMN_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("dataType", (Object)dataType);
        referenceable.set("comment", (Object)comment);
        return referenceable;
    }

    protected Id table(String name, String description, Id dbId, Referenceable sd, String owner, String tableType, List<Referenceable> columns, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(HIVE_TABLE_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("qualifiedName", (Object)("qualified:" + name));
        referenceable.set("description", (Object)description);
        referenceable.set("owner", (Object)owner);
        referenceable.set("tableType", (Object)tableType);
        referenceable.set("temporary", (Object)false);
        referenceable.set("createTime", (Object)new Date(System.currentTimeMillis()));
        referenceable.set("lastAccessTime", (Object)System.currentTimeMillis());
        referenceable.set("retention", (Object)System.currentTimeMillis());
        referenceable.set("db", (Object)dbId);
        referenceable.set("sd", (Object)sd);
        referenceable.set("columns", columns);
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, HIVE_TABLE_TYPE);
        return this.createInstance(referenceable, clsType);
    }

    protected Id loadProcess(String name, String description, String user, List<Id> inputTables, List<Id> outputTables, String queryText, String queryPlan, String queryId, String queryGraph, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(HIVE_PROCESS_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("qualifiedName", (Object)name);
        referenceable.set("description", (Object)description);
        referenceable.set("user", (Object)user);
        referenceable.set("startTime", (Object)System.currentTimeMillis());
        referenceable.set("endTime", (Object)(System.currentTimeMillis() + 10000L));
        referenceable.set("inputs", inputTables);
        referenceable.set("outputs", outputTables);
        referenceable.set("queryText", (Object)queryText);
        referenceable.set("queryPlan", (Object)queryPlan);
        referenceable.set("queryId", (Object)queryId);
        referenceable.set("queryGraph", (Object)queryGraph);
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, HIVE_PROCESS_TYPE);
        return this.createInstance(referenceable, clsType);
    }

    Id view(String name, Id dbId, List<Id> inputTables, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(VIEW_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("qualifiedName", (Object)name);
        referenceable.set("db", (Object)dbId);
        referenceable.set("inputTables", inputTables);
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, VIEW_TYPE);
        return this.createInstance(referenceable, clsType);
    }

    Id partition(List<String> values, Id table, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(PARTITION_TYPE, traitNames);
        referenceable.set("values", values);
        referenceable.set("table", (Object)table);
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, PARTITION_TYPE);
        return this.createInstance(referenceable, clsType);
    }

    Id datasetSubType(String name, String owner) throws Exception {
        Referenceable referenceable = new Referenceable(DATASET_SUBTYPE, new String[0]);
        referenceable.set("qualifiedName", (Object)name);
        referenceable.set("name", (Object)name);
        referenceable.set("owner", (Object)owner);
        ClassType clsType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, DATASET_SUBTYPE);
        return this.createInstance(referenceable, clsType);
    }

    private Id createInstance(Referenceable referenceable, ClassType clsType) throws Exception {
        ITypedReferenceableInstance typedInstance = clsType.convert((Object)referenceable, Multiplicity.REQUIRED);
        List guids = this.repository.createEntities(new ITypedReferenceableInstance[]{typedInstance});
        return new Id((String)guids.get(guids.size() - 1), 0, referenceable.getTypeName());
    }
}

