/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.plugin.classloader;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import org.apache.atlas.plugin.classloader.AtlasPluginClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasPluginClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPluginClassLoader.class);
    private static volatile AtlasPluginClassLoader me = null;
    private final MyClassLoader componentClassLoader = AccessController.doPrivileged(new PrivilegedAction<MyClassLoader>(){

        @Override
        public MyClassLoader run() {
            return new MyClassLoader(Thread.currentThread().getContextClassLoader());
        }
    });

    private AtlasPluginClassLoader(String pluginType, Class<?> pluginClass) throws URISyntaxException {
        this(AtlasPluginClassLoaderUtil.getPluginImplLibPath(pluginType, pluginClass));
    }

    AtlasPluginClassLoader(String libraryPath) {
        super(AtlasPluginClassLoaderUtil.getFilesInDirectories(new String[]{libraryPath}), (ClassLoader)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtlasPluginClassLoader getInstance(final String pluginType, final Class<?> pluginClass) throws PrivilegedActionException {
        AtlasPluginClassLoader ret = me;
        if (ret != null) return ret;
        Class<AtlasPluginClassLoader> clazz = AtlasPluginClassLoader.class;
        synchronized (AtlasPluginClassLoader.class) {
            ret = me;
            if (ret != null) return ret;
            me = AccessController.doPrivileged(new PrivilegedExceptionAction<AtlasPluginClassLoader>(){

                @Override
                public AtlasPluginClassLoader run() throws URISyntaxException {
                    return new AtlasPluginClassLoader(pluginType, pluginClass);
                }
            });
            return me;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block6: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("==> AtlasPluginClassLoader.findClass({})", (Object)name);
            }
            ret = null;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("AtlasPluginClassLoader.findClass({}): calling pluginClassLoader.findClass()", (Object)name);
                }
                ret = super.findClass(name);
            }
            catch (Throwable e) {
                MyClassLoader savedClassLoader = this.getComponentClassLoader();
                if (savedClassLoader == null) break block6;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("AtlasPluginClassLoader.findClass({}): calling componentClassLoader.findClass()", (Object)name);
                }
                ret = savedClassLoader.findClass(name);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== AtlasPluginClassLoader.findClass({}): {}", (Object)name, ret);
        }
        return ret;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block6: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("==> AtlasPluginClassLoader.loadClass({})", (Object)name);
            }
            ret = null;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("AtlasPluginClassLoader.loadClass({}): calling pluginClassLoader.loadClass()", (Object)name);
                }
                ret = super.loadClass(name);
            }
            catch (Throwable e) {
                MyClassLoader savedClassLoader = this.getComponentClassLoader();
                if (savedClassLoader == null) break block6;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("AtlasPluginClassLoader.loadClass({}): calling componentClassLoader.loadClass()", (Object)name);
                }
                ret = savedClassLoader.loadClass(name);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<== AtlasPluginClassLoader.loadClass({}): {}", (Object)name, ret);
        }
        return ret;
    }

    @Override
    public URL findResource(String name) {
        MyClassLoader savedClassLoader;
        URL ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoader.findResource({}) ", (Object)name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasPluginClassLoader.findResource({}): calling pluginClassLoader.findResource()", (Object)name);
        }
        if ((ret = super.findResource(name)) == null && (savedClassLoader = this.getComponentClassLoader()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasPluginClassLoader.findResource({}): calling componentClassLoader.getResource()", (Object)name);
            }
            ret = savedClassLoader.getResource(name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoader.findResource({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoader.findResources({})", (Object)name);
        }
        Enumeration<URL> ret = null;
        MergeEnumeration resourcesInPluginClsLoader = this.findResourcesUsingPluginClassLoader(name);
        Enumeration<URL> resourcesInComponentClsLoader = this.findResourcesUsingComponentClassLoader(name);
        ret = resourcesInPluginClsLoader != null && resourcesInComponentClsLoader != null ? new MergeEnumeration(resourcesInPluginClsLoader, resourcesInComponentClsLoader) : (resourcesInPluginClsLoader != null ? resourcesInPluginClsLoader : resourcesInComponentClsLoader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoader.findResources({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    public void activate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoader.activate()");
        }
        Thread.currentThread().setContextClassLoader(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoader.activate()");
        }
    }

    public void deactivate() {
        MyClassLoader savedClassLoader;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoader.deactivate()");
        }
        if ((savedClassLoader = this.getComponentClassLoader()) != null && savedClassLoader.getParent() != null) {
            Thread.currentThread().setContextClassLoader(savedClassLoader.getParent());
        } else {
            LOG.warn("AtlasPluginClassLoader.deactivate() was not successful.Couldn't not get the saved componentClassLoader...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoader.deactivate()");
        }
    }

    private MyClassLoader getComponentClassLoader() {
        return this.componentClassLoader;
    }

    private Enumeration<URL> findResourcesUsingPluginClassLoader(String name) {
        Enumeration<URL> ret;
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasPluginClassLoader.findResourcesUsingPluginClassLoader({})", (Object)name);
            }
            ret = null;
            try {
                ret = super.findResources(name);
            }
            catch (Throwable excp) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("AtlasPluginClassLoader.findResourcesUsingPluginClassLoader({}): resource not found in plugin", (Object)name, (Object)excp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoader.findResourcesUsingPluginClassLoader({}): {}", (Object)name, ret);
        }
        return ret;
    }

    private Enumeration<URL> findResourcesUsingComponentClassLoader(String name) {
        Enumeration<URL> ret;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasPluginClassLoader.findResourcesUsingComponentClassLoader({})", (Object)name);
            }
            ret = null;
            try {
                MyClassLoader savedClassLoader = this.getComponentClassLoader();
                if (savedClassLoader != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("AtlasPluginClassLoader.findResourcesUsingComponentClassLoader({}): calling componentClassLoader.getResources()", (Object)name);
                    }
                    ret = savedClassLoader.getResources(name);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== AtlasPluginClassLoader.findResourcesUsingComponentClassLoader({}): {}", (Object)name, ret);
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("AtlasPluginClassLoader.findResourcesUsingComponentClassLoader({}): class not found in componentClassLoader.", (Object)name, (Object)t);
            }
        }
        return ret;
    }

    static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader realClassLoader) {
            super(realClassLoader);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }

    static class MergeEnumeration
    implements Enumeration<URL> {
        private Enumeration<URL> e1 = null;
        private Enumeration<URL> e2 = null;

        public MergeEnumeration(Enumeration<URL> e1, Enumeration<URL> e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e1 != null && this.e1.hasMoreElements() || this.e2 != null && this.e2.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL ret = null;
            if (this.e1 != null && this.e1.hasMoreElements()) {
                ret = this.e1.nextElement();
            } else if (this.e2 != null && this.e2.hasMoreElements()) {
                ret = this.e2.nextElement();
            }
            return ret;
        }
    }
}

