/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Preconditions;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.AtlasVertexQuery;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusObjectFactory;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.janusgraph.core.JanusGraphVertexQuery;

public class AtlasJanusVertexQuery
implements AtlasVertexQuery<AtlasJanusVertex, AtlasJanusEdge> {
    private AtlasJanusGraph graph;
    private JanusGraphVertexQuery<?> query;

    public AtlasJanusVertexQuery(AtlasJanusGraph graph, JanusGraphVertexQuery<?> query) {
        this.query = query;
        this.graph = graph;
    }

    public AtlasVertexQuery<AtlasJanusVertex, AtlasJanusEdge> direction(AtlasEdgeDirection queryDirection) {
        this.query.direction(AtlasJanusObjectFactory.createDirection(queryDirection));
        return this;
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices() {
        Iterable vertices = this.query.vertices();
        return this.graph.wrapVertices(vertices);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> vertices(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Limit should be greater than or equals to 0");
        Iterable vertices = this.query.limit(limit).vertices();
        return this.graph.wrapVertices(vertices);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges() {
        Iterable edges = this.query.edges();
        return this.graph.wrapEdges(edges);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> edges(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Limit should be greater than or equals to 0");
        Iterable edges = this.query.limit(limit).edges();
        return this.graph.wrapEdges(edges);
    }

    public long count() {
        return this.query.count();
    }
}

