/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasEdgeLabel;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusObjectFactory;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphManagement
implements AtlasGraphManagement {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphManagement.class);
    private static final char[] RESERVED_CHARS = new char[]{'{', '}', '\"', '$', '\u001e'};
    private AtlasJanusGraph graph;
    private JanusGraphManagement management;
    private Set<String> newMultProperties = new HashSet<String>();

    public AtlasJanusGraphManagement(AtlasJanusGraph graph, JanusGraphManagement managementSystem) {
        this.management = managementSystem;
        this.graph = graph;
    }

    public void createVertexIndex(String propertyName, String backingIndex, List<AtlasPropertyKey> propertyKeys) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(propertyName, Vertex.class);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey);
        }
        indexBuilder.buildMixedIndex(backingIndex);
    }

    public void createEdgeIndex(String index, String backingIndex) {
        this.buildMixedIndex(index, Edge.class, backingIndex);
    }

    private void buildMixedIndex(String index, Class<? extends Element> janusClass, String backingIndex) {
        this.management.buildIndex(index, janusClass).buildMixedIndex(backingIndex);
    }

    public void createFullTextIndex(String indexName, AtlasPropertyKey propertyKey, String backingIndex) {
        PropertyKey fullText = AtlasJanusObjectFactory.createPropertyKey(propertyKey);
        this.management.buildIndex(indexName, Vertex.class).addKey(fullText, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)}).buildMixedIndex(backingIndex);
    }

    public boolean containsPropertyKey(String propertyName) {
        return this.management.containsPropertyKey(propertyName);
    }

    public void rollback() {
        this.management.rollback();
    }

    public void commit() {
        this.graph.addMultiProperties(this.newMultProperties);
        this.newMultProperties.clear();
        this.management.commit();
    }

    private static void checkName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Need to specify name");
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name can not contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf(c), name});
        }
    }

    public AtlasPropertyKey makePropertyKey(String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        if (cardinality.isMany()) {
            this.newMultProperties.add(propertyName);
        }
        PropertyKeyMaker propertyKeyBuilder = this.management.makePropertyKey(propertyName).dataType(propertyClass);
        if (cardinality != null) {
            Cardinality janusCardinality = AtlasJanusObjectFactory.createCardinality(cardinality);
            propertyKeyBuilder.cardinality(janusCardinality);
        }
        PropertyKey propertyKey = propertyKeyBuilder.make();
        return GraphDbObjectFactory.createPropertyKey(propertyKey);
    }

    public AtlasEdgeLabel makeEdgeLabel(String label) {
        EdgeLabel edgeLabel = this.management.makeEdgeLabel(label).make();
        return GraphDbObjectFactory.createEdgeLabel(edgeLabel);
    }

    public void deletePropertyKey(String propertyKey) {
        String deletedKeyName;
        PropertyKey janusPropertyKey = this.management.getPropertyKey(propertyKey);
        if (null == janusPropertyKey) {
            return;
        }
        int i = 0;
        while (true) {
            if (null == this.management.getPropertyKey(deletedKeyName = janusPropertyKey + "_deleted_" + i)) break;
            ++i;
        }
        this.management.changeName((JanusGraphSchemaElement)janusPropertyKey, deletedKeyName);
    }

    public AtlasPropertyKey getPropertyKey(String propertyName) {
        AtlasJanusGraphManagement.checkName(propertyName);
        return GraphDbObjectFactory.createPropertyKey(this.management.getPropertyKey(propertyName));
    }

    public AtlasEdgeLabel getEdgeLabel(String label) {
        return GraphDbObjectFactory.createEdgeLabel(this.management.getEdgeLabel(label));
    }

    public void createExactMatchVertexIndex(String propertyName, boolean enforceUniqueness, List<AtlasPropertyKey> propertyKeys) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(propertyName, Vertex.class);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey);
        }
        if (enforceUniqueness) {
            indexBuilder.unique();
        }
        indexBuilder.buildCompositeIndex();
    }

    public void addVertexIndexKey(String indexName, AtlasPropertyKey propertyKey) {
        PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(propertyKey);
        JanusGraphIndex vertexIndex = this.management.getGraphIndex(indexName);
        this.management.addIndexKey(vertexIndex, janusKey, new Parameter[0]);
    }

    public AtlasGraphIndex getGraphIndex(String indexName) {
        JanusGraphIndex index = this.management.getGraphIndex(indexName);
        return GraphDbObjectFactory.createGraphIndex(index);
    }

    public void createExactMatchIndex(String propertyName, boolean isUnique, List<AtlasPropertyKey> propertyKeys) {
        this.createExactMatchVertexIndex(propertyName, isUnique, propertyKeys);
    }
}

