/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDatabase;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.serializer.BigDecimalSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.BigIntegerSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.TypeCategorySerializer;
import org.apache.atlas.runner.LocalSolrRunner;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.database.serialize.attribute.SerializableSerializer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphDatabase
implements GraphDatabase<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphDatabase.class);
    public static final String GRAPH_PREFIX = "atlas.graph";
    public static final String INDEX_BACKEND_CONF = "index.search.backend";
    public static final String SOLR_ZOOKEEPER_URL = "atlas.graph.index.search.solr.zookeeper-url";
    public static final String INDEX_BACKEND_LUCENE = "lucene";
    public static final String INDEX_BACKEND_ES = "elasticsearch";
    private static volatile AtlasJanusGraph atlasGraphInstance = null;
    private static volatile JanusGraph graphInstance;

    public AtlasJanusGraphDatabase() {
        GraphSONMapper.build().addRegistry((IoRegistry)JanusGraphIoRegistry.getInstance()).create();
    }

    public static Configuration getConfiguration() throws AtlasException {
        AtlasJanusGraphDatabase.startLocalSolr();
        Configuration configProperties = ApplicationProperties.get();
        Configuration janusConfig = ApplicationProperties.getSubsetConfiguration((Configuration)configProperties, (String)GRAPH_PREFIX);
        janusConfig.addProperty("attributes.custom.attribute1.attribute-class", (Object)DataTypes.TypeCategory.class.getName());
        janusConfig.addProperty("attributes.custom.attribute1.serializer-class", (Object)TypeCategorySerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute2.attribute-class", (Object)ArrayList.class.getName());
        janusConfig.addProperty("attributes.custom.attribute2.serializer-class", (Object)SerializableSerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute3.attribute-class", (Object)BigInteger.class.getName());
        janusConfig.addProperty("attributes.custom.attribute3.serializer-class", (Object)BigIntegerSerializer.class.getName());
        janusConfig.addProperty("attributes.custom.attribute4.attribute-class", (Object)BigDecimal.class.getName());
        janusConfig.addProperty("attributes.custom.attribute4.serializer-class", (Object)BigDecimalSerializer.class.getName());
        return janusConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JanusGraph getGraphInstance() {
        if (graphInstance != null) return graphInstance;
        Class<AtlasJanusGraphDatabase> clazz = AtlasJanusGraphDatabase.class;
        synchronized (AtlasJanusGraphDatabase.class) {
            Configuration config;
            if (graphInstance != null) return graphInstance;
            try {
                config = AtlasJanusGraphDatabase.getConfiguration();
            }
            catch (AtlasException e) {
                throw new RuntimeException(e);
            }
            graphInstance = JanusGraphFactory.open((Configuration)config);
            atlasGraphInstance = new AtlasJanusGraph();
            AtlasJanusGraphDatabase.validateIndexBackend(config);
            // ** MonitorExit[var0] (shouldn't be in output)
            return graphInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        Class<AtlasJanusGraphDatabase> clazz = AtlasJanusGraphDatabase.class;
        synchronized (AtlasJanusGraphDatabase.class) {
            if (graphInstance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            graphInstance.tx().commit();
            graphInstance.close();
            graphInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void validateIndexBackend(Configuration config) {
        String configuredIndexBackend = config.getString(INDEX_BACKEND_CONF);
        JanusGraphManagement managementSystem = AtlasJanusGraphDatabase.getGraphInstance().openManagement();
        String currentIndexBackend = managementSystem.get(INDEX_BACKEND_CONF);
        managementSystem.commit();
        if (!configuredIndexBackend.equals(currentIndexBackend)) {
            throw new RuntimeException("Configured Index Backend " + configuredIndexBackend + " differs from earlier configured Index Backend " + currentIndexBackend + ". Aborting!");
        }
    }

    public boolean isGraphLoaded() {
        return graphInstance != null;
    }

    public void initializeTestGraph() {
    }

    public void cleanup() {
        try {
            AtlasJanusGraphDatabase.getGraphInstance().close();
        }
        catch (Throwable t) {
            LOG.warn("Could not close test JanusGraph", t);
            t.printStackTrace();
        }
        try {
            JanusGraphFactory.drop((JanusGraph)AtlasJanusGraphDatabase.getGraphInstance());
        }
        catch (Throwable t) {
            LOG.warn("Could not clear test JanusGraph", t);
            t.printStackTrace();
        }
        try {
            LocalSolrRunner.stop();
        }
        catch (Throwable t) {
            LOG.warn("Could not stop local solr server", t);
        }
    }

    public AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> getGraph() {
        AtlasJanusGraphDatabase.getGraphInstance();
        return atlasGraphInstance;
    }

    private static void startLocalSolr() {
        if (AtlasJanusGraphDatabase.isEmbeddedSolr()) {
            try {
                LocalSolrRunner.start();
                Configuration configuration = ApplicationProperties.get();
                configuration.clearProperty(SOLR_ZOOKEEPER_URL);
                configuration.setProperty(SOLR_ZOOKEEPER_URL, (Object)LocalSolrRunner.getZookeeperUrls());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start embedded solr cloud server. Aborting!", e);
            }
        }
    }

    public static boolean isEmbeddedSolr() {
        boolean ret = false;
        try {
            Configuration conf = ApplicationProperties.get();
            Object property = conf.getProperty("atlas.graph.index.search.solr.embedded");
            if (property != null && property instanceof String) {
                ret = Boolean.valueOf((String)property);
            }
        }
        catch (AtlasException atlasException) {
            // empty catch block
        }
        return ret;
    }
}

