/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.graph;

import java.io.File;
import java.util.UUID;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.SkipException;

public class GraphSandboxUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GraphSandboxUtil.class);

    public static void create(String sandboxName) {
        try {
            Configuration configuration = ApplicationProperties.get();
            configuration.setProperty("atlas.graph.storage.directory", (Object)GraphSandboxUtil.getStorageDir(sandboxName, "storage"));
            configuration.setProperty("atlas.graph.index.search.directory", (Object)GraphSandboxUtil.getStorageDir(sandboxName, "index"));
            LOG.debug("New Storage dir : {}", configuration.getProperty("atlas.graph.storage.directory"));
            LOG.debug("New Indexer dir : {}", configuration.getProperty("atlas.graph.index.search.directory"));
        }
        catch (AtlasException ignored) {
            throw new SkipException("Failure to setup Sandbox: " + sandboxName);
        }
    }

    private static String getStorageDir(String sandboxName, String directory) {
        return System.getProperty("atlas.data") + File.separatorChar + sandboxName + File.separatorChar + directory;
    }

    public static void create() {
        UUID uuid = UUID.randomUUID();
        GraphSandboxUtil.create(uuid.toString());
    }

    public static boolean useLocalSolr() {
        boolean ret = false;
        try {
            Configuration conf = ApplicationProperties.get();
            Object property = conf.getProperty("atlas.graph.index.search.solr.embedded");
            if (property != null && property instanceof String) {
                ret = Boolean.valueOf((String)property);
            }
        }
        catch (AtlasException ignored) {
            throw new SkipException("useLocalSolr: failed! ", (Throwable)ignored);
        }
        return ret;
    }
}

