/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServerEnsemble;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.ResourceCreator;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.security.SecureClientUtils;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AtlasBaseClient {
    public static final String BASE_URI = "api/atlas/";
    public static final String TYPES = "types";
    public static final String ADMIN_VERSION = "admin/version";
    public static final String ADMIN_STATUS = "admin/status";
    public static final String ADMIN_METRICS = "admin/metrics";
    public static final String ADMIN_IMPORT = "admin/import";
    public static final String HTTP_AUTHENTICATION_ENABLED = "atlas.http.authentication.enabled";
    public static final String QUERY = "query";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final String STATUS = "Status";
    public static final API API_STATUS = new API("api/atlas/admin/status", "GET", Response.Status.OK);
    public static final API API_VERSION = new API("api/atlas/admin/version", "GET", Response.Status.OK);
    public static final API API_METRICS = new API("api/atlas/admin/metrics", "GET", Response.Status.OK);
    static final String JSON_MEDIA_TYPE = "application/json; charset=UTF-8";
    static final String UNKNOWN_STATUS = "Unknown status";
    static final String ATLAS_CLIENT_HA_RETRIES_KEY = "atlas.client.ha.retries";
    static final int DEFAULT_NUM_RETRIES = 4;
    static final String ATLAS_CLIENT_HA_SLEEP_INTERVAL_MS_KEY = "atlas.client.ha.sleep.interval.ms";
    static final int DEFAULT_SLEEP_BETWEEN_RETRIES_MS = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(AtlasBaseClient.class);
    private static final API IMPORT = new API("api/atlas/admin/import", "POST", Response.Status.OK, "multipart/form-data", "application/json");
    protected WebResource service;
    protected Configuration configuration;
    private String basicAuthUser;
    private String basicAuthPassword;
    private AtlasClientContext atlasClientContext;
    private boolean retryEnabled = false;
    private Cookie cookie = null;

    protected AtlasBaseClient() {
    }

    protected AtlasBaseClient(String[] baseUrl, String[] basicAuthUserNamePassword) {
        if (basicAuthUserNamePassword != null) {
            if (basicAuthUserNamePassword.length > 0) {
                this.basicAuthUser = basicAuthUserNamePassword[0];
            }
            if (basicAuthUserNamePassword.length > 1) {
                this.basicAuthPassword = basicAuthUserNamePassword[1];
            }
        }
        this.initializeState(baseUrl, null, null);
    }

    protected AtlasBaseClient(String ... baseUrls) throws AtlasException {
        this(AtlasBaseClient.getCurrentUGI(), baseUrls);
    }

    protected AtlasBaseClient(UserGroupInformation ugi, String[] baseUrls) {
        this(ugi, ugi.getShortUserName(), baseUrls);
    }

    protected AtlasBaseClient(UserGroupInformation ugi, String doAsUser, String[] baseUrls) {
        this.initializeState(baseUrls, ugi, doAsUser);
    }

    protected AtlasBaseClient(String[] baseUrls, Cookie cookie) {
        this.cookie = cookie;
        this.initializeState(baseUrls, null, null);
    }

    @VisibleForTesting
    protected AtlasBaseClient(WebResource service, Configuration configuration) {
        this.service = service;
        this.configuration = configuration;
    }

    @VisibleForTesting
    protected AtlasBaseClient(Configuration configuration, String[] baseUrl, String[] basicAuthUserNamePassword) {
        if (basicAuthUserNamePassword != null) {
            if (basicAuthUserNamePassword.length > 0) {
                this.basicAuthUser = basicAuthUserNamePassword[0];
            }
            if (basicAuthUserNamePassword.length > 1) {
                this.basicAuthPassword = basicAuthUserNamePassword[1];
            }
        }
        this.initializeState(configuration, baseUrl, null, null);
    }

    protected static UserGroupInformation getCurrentUGI() throws AtlasException {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public boolean isServerReady() throws AtlasServiceException {
        WebResource resource = this.getResource(API_VERSION.getNormalizedPath(), new String[0]);
        try {
            this.callAPIWithResource(API_VERSION, resource, null, ObjectNode.class);
            return true;
        }
        catch (ClientHandlerException che) {
            return false;
        }
        catch (AtlasServiceException ase) {
            if (ase.getStatus() != null && ase.getStatus().equals((Object)ClientResponse.Status.SERVICE_UNAVAILABLE)) {
                LOG.warn("Received SERVICE_UNAVAILABLE, server is not yet ready");
                return false;
            }
            throw ase;
        }
    }

    public String getAdminStatus() throws AtlasServiceException {
        String result = UNKNOWN_STATUS;
        WebResource resource = this.getResource(this.service, API_STATUS.getNormalizedPath(), new String[0]);
        ObjectNode response = this.callAPIWithResource(API_STATUS, resource, null, ObjectNode.class);
        if (response.has(STATUS)) {
            result = response.get(STATUS).asText();
        }
        return result;
    }

    public AtlasMetrics getAtlasMetrics() throws AtlasServiceException {
        return this.callAPI(API_METRICS, AtlasMetrics.class, null);
    }

    public <T> T callAPI(API api, Class<T> responseType, Object requestObject, String ... params) throws AtlasServiceException {
        return this.callAPIWithResource(api, this.getResource(api, params), requestObject, responseType);
    }

    public <T> T callAPI(API api, GenericType<T> responseType, Object requestObject, String ... params) throws AtlasServiceException {
        return this.callAPIWithResource(api, this.getResource(api, params), requestObject, responseType);
    }

    public <T> T callAPI(API api, Class<T> responseType, Object requestBody, MultivaluedMap<String, String> queryParams, String ... params) throws AtlasServiceException {
        WebResource resource = this.getResource(api, queryParams, params);
        return this.callAPIWithResource(api, resource, requestBody, responseType);
    }

    public <T> T callAPI(API api, Class<T> responseType, MultivaluedMap<String, String> queryParams, String ... params) throws AtlasServiceException {
        WebResource resource = this.getResource(api, queryParams, params);
        return this.callAPIWithResource(api, resource, null, responseType);
    }

    public <T> T callAPI(API api, GenericType<T> responseType, MultivaluedMap<String, String> queryParams, String ... params) throws AtlasServiceException {
        WebResource resource = this.getResource(api, queryParams, params);
        return this.callAPIWithResource(api, resource, null, responseType);
    }

    public <T> T callAPI(API api, Class<T> responseType, MultivaluedMap<String, String> queryParams) throws AtlasServiceException {
        return this.callAPIWithResource(api, this.getResource(api, queryParams), null, responseType);
    }

    public <T> T callAPI(API api, Class<T> responseType, String queryParamKey, List<String> queryParamValues) throws AtlasServiceException {
        return this.callAPIWithResource(api, this.getResource(api, queryParamKey, queryParamValues), null, responseType);
    }

    @VisibleForTesting
    protected Client getClient(Configuration configuration, UserGroupInformation ugi, String doAsUser) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        int readTimeout = configuration.getInt("atlas.client.readTimeoutMSecs", 60000);
        int connectTimeout = configuration.getInt("atlas.client.connectTimeoutMSecs", 60000);
        if (configuration.getBoolean("atlas.enableTLS", false)) {
            try {
                SecureClientUtils.persistSSLClientConfiguration(configuration);
            }
            catch (Exception e) {
                LOG.info("Error processing client configuration.", (Throwable)e);
            }
        }
        URLConnectionClientHandler handler = AuthenticationUtil.isKerberosAuthenticationEnabled() ? SecureClientUtils.getClientConnectionHandler(config, configuration, doAsUser, ugi) : (configuration.getBoolean("atlas.enableTLS", false) ? SecureClientUtils.getUrlConnectionClientHandler() : new URLConnectionClientHandler());
        Client client = new Client((ClientHandler)handler, (ClientConfig)config);
        client.setReadTimeout(Integer.valueOf(readTimeout));
        client.setConnectTimeout(Integer.valueOf(connectTimeout));
        return client;
    }

    @VisibleForTesting
    protected String determineActiveServiceURL(String[] baseUrls, Client client) {
        String baseUrl;
        if (baseUrls.length == 0) {
            throw new IllegalArgumentException("Base URLs cannot be null or empty");
        }
        AtlasServerEnsemble atlasServerEnsemble = new AtlasServerEnsemble(baseUrls);
        if (atlasServerEnsemble.hasSingleInstance()) {
            baseUrl = atlasServerEnsemble.firstURL();
            LOG.info("Client has only one service URL, will use that for all actions: {}", (Object)baseUrl);
        } else {
            try {
                baseUrl = this.selectActiveServerAddress(client, atlasServerEnsemble);
            }
            catch (AtlasServiceException e) {
                LOG.error("None of the passed URLs are active: {}", (Object)atlasServerEnsemble, (Object)e);
                throw new IllegalArgumentException("None of the passed URLs are active " + atlasServerEnsemble, e);
            }
        }
        return baseUrl;
    }

    protected Configuration getClientProperties() {
        try {
            if (this.configuration == null) {
                this.configuration = ApplicationProperties.get();
            }
        }
        catch (AtlasException e) {
            LOG.error("Exception while loading configuration.", (Throwable)e);
        }
        return this.configuration;
    }

    protected WebResource getResource(String path, String ... pathParams) {
        return this.getResource(this.service, path, pathParams);
    }

    protected <T> T callAPIWithResource(API api, WebResource resource, Object requestObject, Class<T> responseType) throws AtlasServiceException {
        GenericType genericType = null;
        if (responseType != null) {
            genericType = new GenericType(responseType);
        }
        return this.callAPIWithResource(api, resource, requestObject, genericType);
    }

    protected <T> T callAPIWithResource(API api, WebResource resource, Object requestObject, GenericType<T> responseType) throws AtlasServiceException {
        ClientResponse clientResponse = null;
        int i = 0;
        do {
            LOG.info("------------------------------------------------------");
            LOG.info("Call         : {} {}", (Object)api.getMethod(), (Object)api.getNormalizedPath());
            LOG.info("Content-type : {} ", (Object)api.getConsumes());
            LOG.info("Accept       : {} ", (Object)api.getProduces());
            if (requestObject != null) {
                LOG.info("Request      : {}", requestObject);
            }
            WebResource.Builder requestBuilder = resource.getRequestBuilder();
            ((WebResource.Builder)requestBuilder.accept(new String[]{api.getProduces()})).type(api.getConsumes());
            if (this.cookie != null) {
                requestBuilder.cookie(this.cookie);
            }
            clientResponse = (ClientResponse)requestBuilder.method(api.getMethod(), ClientResponse.class, requestObject);
            LOG.info("HTTP Status  : {}", (Object)clientResponse.getStatus());
            if (clientResponse.getStatus() == api.getExpectedStatus().getStatusCode()) {
                if (responseType == null) {
                    return null;
                }
                try {
                    if (responseType.getRawClass().equals(ObjectNode.class)) {
                        String stringEntity = (String)clientResponse.getEntity(String.class);
                        try {
                            JsonNode jsonObject = AtlasJson.parseToV1JsonNode((String)stringEntity);
                            LOG.info("Response     : {}", (Object)jsonObject);
                            LOG.info("------------------------------------------------------");
                            return (T)jsonObject;
                        }
                        catch (IOException e) {
                            throw new AtlasServiceException(api, e);
                        }
                    }
                    Object entity = clientResponse.getEntity(responseType);
                    LOG.info("Response     : {}", entity);
                    LOG.info("------------------------------------------------------");
                    return (T)entity;
                }
                catch (ClientHandlerException e) {
                    throw new AtlasServiceException(api, (Exception)((Object)e));
                }
            }
            if (clientResponse.getStatus() != ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode()) break;
            LOG.error("Got a service unavailable when calling: {}, will retry..", (Object)resource);
            this.sleepBetweenRetries();
        } while (++i < this.getNumberOfRetries());
        throw new AtlasServiceException(api, clientResponse);
    }

    protected WebResource getResource(API api, String ... pathParams) {
        return this.getResource(this.service, api, pathParams);
    }

    protected WebResource getResource(API api, MultivaluedMap<String, String> queryParams, String ... pathParams) {
        WebResource resource = this.service.path(api.getNormalizedPath());
        resource = this.appendPathParams(resource, pathParams);
        resource = this.appendQueryParams(queryParams, resource);
        return resource;
    }

    protected WebResource getResource(API api, MultivaluedMap<String, String> queryParams) {
        return this.getResource(this.service, api, queryParams);
    }

    protected abstract API formatPathParameters(API var1, String ... var2);

    void initializeState(String[] baseUrls, UserGroupInformation ugi, String doAsUser) {
        this.initializeState(this.getClientProperties(), baseUrls, ugi, doAsUser);
    }

    void initializeState(Configuration configuration, String[] baseUrls, UserGroupInformation ugi, String doAsUser) {
        this.configuration = configuration;
        Client client = this.getClient(configuration, ugi, doAsUser);
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled() && this.basicAuthUser != null && this.basicAuthPassword != null) {
            HTTPBasicAuthFilter authFilter = new HTTPBasicAuthFilter(this.basicAuthUser, this.basicAuthPassword);
            client.addFilter((ClientFilter)authFilter);
        }
        String activeServiceUrl = this.determineActiveServiceURL(baseUrls, client);
        this.atlasClientContext = new AtlasClientContext(baseUrls, client, ugi, doAsUser);
        this.service = client.resource(UriBuilder.fromUri((String)activeServiceUrl).build(new Object[0]));
    }

    void sleepBetweenRetries() {
        try {
            Thread.sleep(this.getSleepBetweenRetriesMs());
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted from sleeping between retries.", (Throwable)e);
        }
    }

    int getNumberOfRetries() {
        return this.configuration.getInt(ATLAS_CLIENT_HA_RETRIES_KEY, 4);
    }

    public AtlasImportResult importData(AtlasImportRequest request, String absoluteFilePath) throws AtlasServiceException {
        FileDataBodyPart filePart = new FileDataBodyPart("data", new File(absoluteFilePath));
        MultiPart multipartEntity = new FormDataMultiPart().field("request", (Object)AtlasType.toJson((Object)request), MediaType.APPLICATION_JSON_TYPE).bodyPart((BodyPart)filePart);
        return this.callAPI(IMPORT, AtlasImportResult.class, (Object)multipartEntity, new String[0]);
    }

    boolean isRetryableException(ClientHandlerException che) {
        return che.getCause().getClass().equals(IOException.class) || che.getCause().getClass().equals(ConnectException.class);
    }

    void handleClientHandlerException(ClientHandlerException che) {
        if (this.isRetryableException(che)) {
            this.atlasClientContext.getClient().destroy();
            LOG.warn("Destroyed current context while handling ClientHandlerEception.");
            LOG.warn("Will retry and create new context.");
            this.sleepBetweenRetries();
            this.initializeState(this.atlasClientContext.getBaseUrls(), this.atlasClientContext.getUgi(), this.atlasClientContext.getDoAsUser());
            return;
        }
        throw che;
    }

    @VisibleForTesting
    ObjectNode callAPIWithRetries(API api, Object requestObject, ResourceCreator resourceCreator) throws AtlasServiceException {
        for (int i = 0; i < this.getNumberOfRetries(); ++i) {
            WebResource resource = resourceCreator.createResource();
            try {
                LOG.debug("Using resource {} for {} times", (Object)resource.getURI(), (Object)(i + 1));
                return this.callAPIWithResource(api, resource, requestObject, ObjectNode.class);
            }
            catch (ClientHandlerException che) {
                if (i == this.getNumberOfRetries() - 1) {
                    throw che;
                }
                LOG.warn("Handled exception in calling api {}", (Object)api.getNormalizedPath(), (Object)che);
                LOG.warn("Exception's cause: {}", che.getCause().getClass());
                this.handleClientHandlerException(che);
                continue;
            }
        }
        throw new AtlasServiceException(api, new RuntimeException("Could not get response after retries."));
    }

    @VisibleForTesting
    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @VisibleForTesting
    void setService(WebResource resource) {
        this.service = resource;
    }

    private String selectActiveServerAddress(Client client, AtlasServerEnsemble serverEnsemble) throws AtlasServiceException {
        List<String> serverInstances = serverEnsemble.getMembers();
        String activeServerAddress = null;
        for (String serverInstance : serverInstances) {
            LOG.info("Trying with address {}", (Object)serverInstance);
            activeServerAddress = this.getAddressIfActive(client, serverInstance);
            if (activeServerAddress == null) continue;
            LOG.info("Found service {} as active service.", (Object)serverInstance);
            break;
        }
        if (activeServerAddress != null) {
            return activeServerAddress;
        }
        throw new AtlasServiceException(API_STATUS, new RuntimeException("Could not find any active instance"));
    }

    private String getAddressIfActive(Client client, String serverInstance) {
        String activeServerAddress = null;
        for (int i = 0; i < this.getNumberOfRetries(); ++i) {
            try {
                this.service = client.resource(UriBuilder.fromUri((String)serverInstance).build(new Object[0]));
                String adminStatus = this.getAdminStatus();
                if (StringUtils.equals((String)adminStatus, (String)"ACTIVE")) {
                    activeServerAddress = serverInstance;
                    break;
                }
                LOG.info("attempt #{}: Service {} - is not active. status={}", new Object[]{i + 1, serverInstance, adminStatus});
            }
            catch (Exception e) {
                LOG.error("attempt #{}: Service {} - could not get status", new Object[]{i + 1, serverInstance, e});
            }
            this.sleepBetweenRetries();
        }
        return activeServerAddress;
    }

    private WebResource getResource(WebResource service, String path, String ... pathParams) {
        WebResource resource = service.path(path);
        resource = this.appendPathParams(resource, pathParams);
        return resource;
    }

    private int getSleepBetweenRetriesMs() {
        return this.configuration.getInt(ATLAS_CLIENT_HA_SLEEP_INTERVAL_MS_KEY, 5000);
    }

    private WebResource getResource(WebResource service, API api, String ... pathParams) {
        WebResource resource = service.path(api.getNormalizedPath());
        resource = this.appendPathParams(resource, pathParams);
        return resource;
    }

    private WebResource getResource(API api, String queryParamKey, List<String> queryParamValues) {
        WebResource resource = this.service.path(api.getNormalizedPath());
        for (String queryParamValue : queryParamValues) {
            if (!StringUtils.isNotBlank((String)queryParamKey) || !StringUtils.isNotBlank((String)queryParamValue)) continue;
            resource = resource.queryParam(queryParamKey, queryParamValue);
        }
        return resource;
    }

    private WebResource appendPathParams(WebResource resource, String[] pathParams) {
        if (pathParams != null) {
            for (String pathParam : pathParams) {
                resource = resource.path(pathParam);
            }
        }
        return resource;
    }

    private WebResource getResource(WebResource service, API api, MultivaluedMap<String, String> queryParams) {
        WebResource resource = service.path(api.getNormalizedPath());
        resource = this.appendQueryParams(queryParams, resource);
        return resource;
    }

    private WebResource appendQueryParams(MultivaluedMap<String, String> queryParams, WebResource resource) {
        if (null != queryParams && !queryParams.isEmpty()) {
            for (Map.Entry entry : queryParams.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    if (!StringUtils.isNotBlank((String)value)) continue;
                    resource = resource.queryParam((String)entry.getKey(), value);
                }
            }
        }
        return resource;
    }

    private class AtlasClientContext {
        private String[] baseUrls;
        private Client client;
        private String doAsUser;
        private UserGroupInformation ugi;

        public AtlasClientContext(String[] baseUrls, Client client, UserGroupInformation ugi, String doAsUser) {
            this.baseUrls = baseUrls;
            this.client = client;
            this.ugi = ugi;
            this.doAsUser = doAsUser;
        }

        public Client getClient() {
            return this.client;
        }

        public String[] getBaseUrls() {
            return this.baseUrls;
        }

        public String getDoAsUser() {
            return this.doAsUser;
        }

        public UserGroupInformation getUgi() {
            return this.ugi;
        }
    }

    public static class API {
        private final String method;
        private final String path;
        private final String consumes;
        private final String produces;
        private final Response.Status status;

        public API(String path, String method, Response.Status status) {
            this(path, method, status, AtlasBaseClient.JSON_MEDIA_TYPE, "application/json");
        }

        public API(String path, String method, Response.Status status, String consumes, String produces) {
            this.path = path;
            this.method = method;
            this.status = status;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public String getNormalizedPath() {
            return Paths.get(this.path, new String[0]).normalize().toString();
        }

        public Response.Status getExpectedStatus() {
            return this.status;
        }

        public String getConsumes() {
            return this.consumes;
        }

        public String getProduces() {
            return this.produces;
        }
    }
}

