/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import java.util.Collection;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.query.BaseQueryExpression;
import org.apache.atlas.catalog.query.QueryFactory;
import org.apache.lucene.search.TermQuery;

public class TermQueryExpression
extends BaseQueryExpression {
    public TermQueryExpression(TermQuery query, ResourceDefinition resourceDefinition) {
        super(query.getTerm().field(), query.getTerm().text(), resourceDefinition);
    }

    @Override
    public boolean evaluate(Object value) {
        String expectedValue = this.getExpectedValue();
        if (value == null) {
            return expectedValue.equals("null");
        }
        if (value instanceof Collection) {
            return ((Collection)value).contains(expectedValue);
        }
        return expectedValue.equals(QueryFactory.escape(String.valueOf(value)));
    }

    @Override
    public String getExpectedValue() {
        return this.m_expectedValue;
    }
}

