/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.TermPath;
import org.apache.atlas.catalog.definition.EntityResourceDefinition;
import org.apache.atlas.catalog.definition.EntityTagResourceDefinition;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.definition.TaxonomyResourceDefinition;
import org.apache.atlas.catalog.definition.TermResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidQueryException;
import org.apache.atlas.catalog.query.AlwaysQueryExpression;
import org.apache.atlas.catalog.query.AtlasEntityQuery;
import org.apache.atlas.catalog.query.AtlasEntityTagQuery;
import org.apache.atlas.catalog.query.AtlasQuery;
import org.apache.atlas.catalog.query.AtlasTaxonomyQuery;
import org.apache.atlas.catalog.query.AtlasTermQuery;
import org.apache.atlas.catalog.query.BooleanQueryExpression;
import org.apache.atlas.catalog.query.PrefixQueryExpression;
import org.apache.atlas.catalog.query.ProjectionQueryExpression;
import org.apache.atlas.catalog.query.QueryExpression;
import org.apache.atlas.catalog.query.RegexQueryExpression;
import org.apache.atlas.catalog.query.TermQueryExpression;
import org.apache.atlas.catalog.query.TermRangeQueryExpression;
import org.apache.atlas.catalog.query.WildcardQueryExpression;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.sandbox.queries.regex.RegexQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(QueryFactory.class);
    public static final String PATH_SEP_TOKEN = "__slash__";
    private final Map<Class<? extends Query>, ExpressionCreateFunction<? extends Query>> expressionCreateFunctions = new HashMap<Class<? extends Query>, ExpressionCreateFunction<? extends Query>>();

    public QueryFactory() {
        this.registerExpressionCreateFunctions();
    }

    public AtlasQuery createTaxonomyQuery(Request request) throws InvalidQueryException {
        TaxonomyResourceDefinition taxonomyDefinition = new TaxonomyResourceDefinition();
        QueryExpression queryExpression = this.create(request, (ResourceDefinition)taxonomyDefinition);
        return new AtlasTaxonomyQuery(queryExpression, taxonomyDefinition, request);
    }

    public AtlasQuery createTermQuery(Request request) throws InvalidQueryException {
        TermResourceDefinition termDefinition = new TermResourceDefinition();
        QueryExpression queryExpression = this.create(request, (ResourceDefinition)termDefinition);
        TermPath termPath = (TermPath)request.getProperty("termPath");
        return new AtlasTermQuery(queryExpression, termDefinition, termPath, request);
    }

    public AtlasQuery createEntityQuery(Request request) throws InvalidQueryException {
        EntityResourceDefinition entityDefinition = new EntityResourceDefinition();
        QueryExpression queryExpression = this.create(request, (ResourceDefinition)entityDefinition);
        return new AtlasEntityQuery(queryExpression, entityDefinition, request);
    }

    public AtlasQuery createEntityTagQuery(Request request) throws InvalidQueryException {
        EntityTagResourceDefinition entityTagDefinition = new EntityTagResourceDefinition();
        QueryExpression queryExpression = this.create(request, (ResourceDefinition)entityTagDefinition);
        String guid = (String)request.getProperty("id");
        return new AtlasEntityTagQuery(queryExpression, entityTagDefinition, guid, request);
    }

    private QueryExpression create(Request request, ResourceDefinition resourceDefinition) throws InvalidQueryException {
        QueryExpression queryExpression;
        String queryString;
        if (request.getCardinality() == Request.Cardinality.INSTANCE) {
            String idPropertyName = resourceDefinition.getIdPropertyName();
            queryString = String.format("%s:%s", idPropertyName, request.getProperty(idPropertyName));
        } else {
            queryString = request.getQueryString();
        }
        if (queryString != null && !queryString.isEmpty()) {
            Query query;
            QueryParser queryParser = new QueryParser(Version.LUCENE_48, "name", (Analyzer)new KeywordAnalyzer());
            queryParser.setLowercaseExpandedTerms(false);
            queryParser.setAllowLeadingWildcard(true);
            try {
                query = queryParser.parse((String)QueryFactory.escape(queryString));
            }
            catch (ParseException e) {
                throw new InvalidQueryException(e.getMessage());
            }
            LOG.info("LuceneQuery: " + query);
            queryExpression = this.create(query, resourceDefinition);
        } else {
            queryExpression = new AlwaysQueryExpression();
        }
        request.addAdditionalSelectProperties(queryExpression.getProperties());
        return queryExpression;
    }

    protected <T extends Query> QueryExpression create(T query, ResourceDefinition resourceDefinition) {
        if (!this.expressionCreateFunctions.containsKey(query.getClass())) {
            throw new CatalogRuntimeException("Query type currently not supported: " + query.getClass(), 400);
        }
        ExpressionCreateFunction<? extends Query> expressionCreateFunction = this.expressionCreateFunctions.get(query.getClass());
        return expressionCreateFunction.createExpression(query, resourceDefinition);
    }

    protected static Object escape(Object val) {
        if (val instanceof String) {
            return ((String)val).replaceAll("/", PATH_SEP_TOKEN);
        }
        return val;
    }

    private void registerExpressionCreateFunctions() {
        this.expressionCreateFunctions.put(WildcardQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<WildcardQuery>(){

            @Override
            public QueryExpression create(WildcardQuery query, ResourceDefinition definition) {
                return new WildcardQueryExpression(query, definition);
            }
        });
        this.expressionCreateFunctions.put(PrefixQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<PrefixQuery>(){

            @Override
            public QueryExpression create(PrefixQuery query, ResourceDefinition definition) {
                return new PrefixQueryExpression(query, definition);
            }
        });
        this.expressionCreateFunctions.put(TermQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<TermQuery>(){

            @Override
            public QueryExpression create(TermQuery query, ResourceDefinition definition) {
                return new TermQueryExpression(query, definition);
            }
        });
        this.expressionCreateFunctions.put(TermRangeQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<TermRangeQuery>(){

            @Override
            public QueryExpression create(TermRangeQuery query, ResourceDefinition definition) {
                return new TermRangeQueryExpression(query, definition);
            }
        });
        this.expressionCreateFunctions.put(RegexQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<RegexQuery>(){

            @Override
            public QueryExpression create(RegexQuery query, ResourceDefinition definition) {
                return new RegexQueryExpression(query, definition);
            }
        });
        this.expressionCreateFunctions.put(BooleanQuery.class, (ExpressionCreateFunction<? extends Query>)new ExpressionCreateFunction<BooleanQuery>(){

            @Override
            public QueryExpression create(BooleanQuery query, ResourceDefinition definition) {
                return new BooleanQueryExpression(query, definition, QueryFactory.this);
            }
        });
    }

    private static abstract class ExpressionCreateFunction<T extends Query> {
        private ExpressionCreateFunction() {
        }

        QueryExpression createExpression(T query, ResourceDefinition resourceDefinition) {
            QueryExpression expression = this.create(query, resourceDefinition);
            return expression.isProjectionExpression() ? new ProjectionQueryExpression(expression, resourceDefinition) : expression;
        }

        protected abstract QueryExpression create(T var1, ResourceDefinition var2);
    }
}

