/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.AndFilterPipe;
import com.tinkerpop.pipes.filter.OrFilterPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.query.BaseQueryExpression;
import org.apache.atlas.catalog.query.QueryExpression;
import org.apache.atlas.catalog.query.QueryFactory;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;

public class BooleanQueryExpression
extends BaseQueryExpression {
    private final BooleanClause[] clauses;
    private final QueryFactory queryFactory;

    public BooleanQueryExpression(BooleanQuery query, ResourceDefinition resourceDefinition, QueryFactory queryFactory) {
        super(null, null, resourceDefinition);
        this.clauses = query.getClauses();
        this.queryFactory = queryFactory;
    }

    @Override
    public Pipe asPipe() {
        Collection<Pipe> orPipes;
        Map<BooleanClause.Occur, Collection<BooleanClause>> groupedClauses = this.groupClauses();
        AndFilterPipe andPipe = null;
        Collection<Pipe> andPipes = this.processAndClauses(groupedClauses);
        andPipes.addAll(this.processNotClauses(groupedClauses));
        if (!andPipes.isEmpty()) {
            andPipe = new AndFilterPipe(andPipes.toArray(new Pipe[andPipes.size()]));
        }
        if (!(orPipes = this.processOrClauses(groupedClauses)).isEmpty()) {
            if (andPipe != null) {
                orPipes.add((Pipe)andPipe);
            }
            return new OrFilterPipe(orPipes.toArray(new Pipe[orPipes.size()]));
        }
        return andPipe;
    }

    private Map<BooleanClause.Occur, Collection<BooleanClause>> groupClauses() {
        HashMap<BooleanClause.Occur, Collection<BooleanClause>> groupedClauses = new HashMap<BooleanClause.Occur, Collection<BooleanClause>>();
        for (BooleanClause clause : this.clauses) {
            BooleanClause.Occur occur = this.resolveClauseOccur(clause);
            ArrayList<BooleanClause> clauseGrouping = (ArrayList<BooleanClause>)groupedClauses.get(occur);
            if (clauseGrouping == null) {
                clauseGrouping = new ArrayList<BooleanClause>();
                groupedClauses.put(occur, clauseGrouping);
            }
            clauseGrouping.add(clause);
        }
        return groupedClauses;
    }

    private BooleanClause.Occur resolveClauseOccur(BooleanClause clause) {
        BooleanClause.Occur occur = clause.getOccur();
        if (this.negate) {
            switch (occur) {
                case SHOULD: {
                    occur = BooleanClause.Occur.MUST_NOT;
                    break;
                }
                case MUST: {
                    occur = BooleanClause.Occur.SHOULD;
                    break;
                }
                case MUST_NOT: {
                    occur = BooleanClause.Occur.SHOULD;
                }
            }
        }
        return occur;
    }

    private Collection<Pipe> processAndClauses(Map<BooleanClause.Occur, Collection<BooleanClause>> groupedClauses) {
        Collection<BooleanClause> andClauses = groupedClauses.get(BooleanClause.Occur.MUST);
        ArrayList<Pipe> andPipes = new ArrayList<Pipe>();
        if (andClauses != null) {
            for (BooleanClause andClause : andClauses) {
                QueryExpression queryExpression = this.queryFactory.create(andClause.getQuery(), this.resourceDefinition);
                this.properties.addAll(queryExpression.getProperties());
                andPipes.add(queryExpression.asPipe());
            }
        }
        return andPipes;
    }

    private Collection<Pipe> processOrClauses(Map<BooleanClause.Occur, Collection<BooleanClause>> groupedClauses) {
        Collection<BooleanClause> shouldClauses = groupedClauses.get(BooleanClause.Occur.SHOULD);
        ArrayList<Pipe> orPipes = new ArrayList<Pipe>();
        if (shouldClauses != null) {
            for (BooleanClause shouldClause : shouldClauses) {
                QueryExpression queryExpression = this.queryFactory.create(shouldClause.getQuery(), this.resourceDefinition);
                if (this.negate && shouldClause.getOccur() != BooleanClause.Occur.MUST_NOT) {
                    queryExpression.setNegate();
                }
                this.properties.addAll(queryExpression.getProperties());
                orPipes.add(queryExpression.asPipe());
            }
        }
        return orPipes;
    }

    private Collection<Pipe> processNotClauses(Map<BooleanClause.Occur, Collection<BooleanClause>> groupedClauses) {
        Collection<BooleanClause> notClauses = groupedClauses.get(BooleanClause.Occur.MUST_NOT);
        ArrayList<Pipe> notPipes = new ArrayList<Pipe>();
        if (notClauses != null) {
            for (BooleanClause notClause : notClauses) {
                QueryExpression queryExpression = this.queryFactory.create(notClause.getQuery(), this.resourceDefinition);
                queryExpression.setNegate();
                this.properties.addAll(queryExpression.getProperties());
                notPipes.add(queryExpression.asPipe());
            }
        }
        return notPipes;
    }
}

