/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.TermVertexWrapper;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.query.BaseQuery;
import org.apache.atlas.catalog.query.QueryExpression;

public class AtlasEntityTagQuery
extends BaseQuery {
    private final String guid;

    public AtlasEntityTagQuery(QueryExpression queryExpression, ResourceDefinition resourceDefinition, String guid, Request request) {
        super(queryExpression, resourceDefinition, request);
        this.guid = guid;
    }

    @Override
    protected Pipe getQueryPipe() {
        GremlinPipeline p = this.guid.equals("*") ? new GremlinPipeline().has("entityText").hasNot("__typeName", (Object)"Taxonomy").outE(new String[0]) : new GremlinPipeline().has("__guid", (Object)this.guid).outE(new String[0]);
        p.add((Pipe)new FilterFunctionPipe((PipeFunction)new PipeFunction<Edge, Boolean>(){

            public Boolean compute(Edge edge) {
                String type = (String)edge.getVertex(Direction.OUT).getProperty("__typeName");
                TermVertexWrapper v = new TermVertexWrapper(edge.getVertex(Direction.IN));
                return edge.getLabel().startsWith(type) && v.getPropertyKeys().contains("available_as_tag");
            }
        }));
        return p.inV();
    }

    @Override
    protected void addHref(VertexWrapper vWrapper, Map<String, Object> filteredPropertyMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(filteredPropertyMap);
        if (this.guid.equals("*")) {
            map.put("entity-guid", ((Edge)vWrapper.getVertex().getEdges(Direction.IN, new String[0]).iterator().next()).getVertex(Direction.OUT).getProperty("__guid"));
        } else {
            map.put("entity-guid", this.guid);
        }
        String href = this.resourceDefinition.resolveHref(map);
        if (href != null) {
            filteredPropertyMap.put("href", href);
        }
    }
}

