/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.projection;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.atlas.catalog.TermVertexWrapper;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.EntityTagResourceDefinition;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.projection.BaseRelation;
import org.apache.atlas.catalog.projection.RelationSet;

public class TraitRelation
extends BaseRelation {
    private static ResourceDefinition resourceDefinition = new EntityTagResourceDefinition();

    @Override
    public Collection<RelationSet> traverse(VertexWrapper vWrapper) {
        Vertex v = vWrapper.getVertex();
        ArrayList<VertexWrapper> vertices = new ArrayList<VertexWrapper>();
        for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
            TermVertexWrapper trait;
            if (!e.getLabel().startsWith((String)v.getProperty("__typeName")) || (trait = new TermVertexWrapper(e.getVertex(Direction.IN))).getPropertyKeys().contains("available_as_tag") || this.isDeleted(trait.getVertex())) continue;
            vertices.add(trait);
        }
        return Collections.singletonList(new RelationSet("traits", vertices));
    }

    @Override
    public Pipe asPipe() {
        return new FilterFunctionPipe((PipeFunction)new PipeFunction<Edge, Boolean>(){

            public Boolean compute(Edge edge) {
                String name = (String)edge.getVertex(Direction.OUT).getProperty("__typeName");
                if (edge.getLabel().startsWith(name)) {
                    TermVertexWrapper v = new TermVertexWrapper(edge.getVertex(Direction.IN));
                    return !v.getPropertyKeys().contains("available_as_tag") && !TraitRelation.this.isDeleted(v.getVertex());
                }
                return false;
            }
        });
    }

    @Override
    public ResourceDefinition getResourceDefinition() {
        return resourceDefinition;
    }
}

