/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.projection;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import java.util.Collection;
import java.util.Collections;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.projection.ProjectionResult;

public class Projection {
    private final String m_name;
    private final Cardinality m_cardinality;
    protected Pipeline<VertexWrapper, Collection<ProjectionResult>> m_pipeline = new Pipeline();

    public Projection(String name, Cardinality cardinality) {
        this.m_name = name;
        this.m_cardinality = cardinality;
    }

    public Projection(String name, Cardinality cardinality, Pipe<VertexWrapper, Collection<ProjectionResult>> pipe) {
        this.m_name = name;
        this.m_cardinality = cardinality;
        this.m_pipeline.addPipe(pipe);
    }

    public Collection<ProjectionResult> values(VertexWrapper start) {
        this.m_pipeline.setStarts(Collections.singleton(start));
        return (Collection)this.m_pipeline.iterator().next();
    }

    public void addPipe(Pipe<Collection<ProjectionResult>, Collection<ProjectionResult>> p) {
        this.m_pipeline.addPipe(p);
    }

    public String getName() {
        return this.m_name;
    }

    public Cardinality getCardinality() {
        return this.m_cardinality;
    }

    public static enum Cardinality {
        SINGLE,
        MULTIPLE;

    }
}

