/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.definition;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.BaseResourceDefinition;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.utils.TypesUtil;

public class TaxonomyResourceDefinition
extends BaseResourceDefinition {
    public TaxonomyResourceDefinition() {
        this.registerProperty(TypesUtil.createUniqueRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE));
        this.registerProperty(TypesUtil.createOptionalAttrDef((String)"description", (IDataType)DataTypes.STRING_TYPE));
        this.registerProperty(TypesUtil.createOptionalAttrDef((String)"taxonomy.namespace", (IDataType)DataTypes.STRING_TYPE));
        this.instanceProperties.add("name");
        this.instanceProperties.add("description");
        this.instanceProperties.add("creation_time");
        this.collectionProperties.add("name");
        this.collectionProperties.add("description");
        this.projections.put("terms", this.getTermsProjection());
    }

    @Override
    public void validateCreatePayload(Request request) throws InvalidPayloadException {
        super.validateCreatePayload(request);
        if (String.valueOf(request.getQueryProperties().get("name")).contains(".")) {
            throw new InvalidPayloadException("The \"name\" property may not contain the character '.'");
        }
    }

    @Override
    public String getTypeName() {
        return "Taxonomy";
    }

    @Override
    public String getIdPropertyName() {
        return "name";
    }

    @Override
    public String resolveHref(Map<String, Object> properties) {
        return String.format("v1/taxonomies/%s", properties.get("name"));
    }

    private Projection getTermsProjection() {
        String termsProjectionName = "terms";
        return new Projection("terms", Projection.Cardinality.SINGLE, (Pipe<VertexWrapper, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<VertexWrapper, Collection<ProjectionResult>>(){
            private String baseHref = "v1/taxonomies/";

            public Collection<ProjectionResult> compute(VertexWrapper v) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("href", this.baseHref + v.getProperty("name") + "/terms");
                return Collections.singleton(new ProjectionResult("terms", v, Collections.singleton(map)));
            }
        }));
    }
}

