/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.Collection;
import java.util.Map;
import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.BaseResourceProvider;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceProvider;
import org.apache.atlas.catalog.Result;
import org.apache.atlas.catalog.definition.EntityResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.exception.InvalidQueryException;
import org.apache.atlas.catalog.exception.ResourceAlreadyExistsException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.query.AtlasQuery;

public class EntityResourceProvider
extends BaseResourceProvider
implements ResourceProvider {
    public EntityResourceProvider(AtlasTypeSystem typeSystem) {
        super(typeSystem, new EntityResourceDefinition());
    }

    @Override
    public Result getResourceById(Request request) throws ResourceNotFoundException {
        AtlasQuery atlasQuery;
        try {
            atlasQuery = this.queryFactory.createEntityQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Entity query: " + e, e);
        }
        Collection<Map<String, Object>> results = atlasQuery.execute();
        if (results.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Entity '%s' not found.", request.getProperty(this.resourceDefinition.getIdPropertyName())));
        }
        return new Result(results);
    }

    @Override
    public Result getResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        AtlasQuery atlasQuery = this.queryFactory.createEntityQuery(request);
        return new Result(atlasQuery.execute());
    }

    @Override
    public void createResource(Request request) throws InvalidPayloadException, ResourceAlreadyExistsException, ResourceNotFoundException {
        throw new UnsupportedOperationException("Creation of entities is not currently supported");
    }

    @Override
    public Collection<String> createResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        throw new UnsupportedOperationException("Creation of entities is not currently supported");
    }
}

