/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.ResourceAlreadyExistsException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.classification.InterfaceAudience;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.exception.EntityExistsException;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.TraitNotFoundException;
import org.apache.atlas.typesystem.exception.TypeExistsException;
import org.apache.atlas.typesystem.exception.TypeNotFoundException;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalType;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.utils.TypesUtil;

public class DefaultTypeSystem
implements AtlasTypeSystem {
    private final MetadataService metadataService;

    public DefaultTypeSystem(MetadataService metadataService) throws AtlasException {
        this.metadataService = metadataService;
        this.createSuperTypes();
    }

    @InterfaceAudience.Private
    private void createSuperTypes() throws AtlasException {
        HierarchicalTypeDefinition termType = TypesUtil.createTraitTypeDef((String)"TaxonomyTerm", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"taxonomy.namespace", (IDataType)DataTypes.STRING_TYPE)});
        this.createTraitType((HierarchicalTypeDefinition<TraitType>)termType);
    }

    private void createTraitType(HierarchicalTypeDefinition<TraitType> type) throws AtlasException {
        try {
            this.metadataService.getTypeDefinition(type.typeName);
        }
        catch (TypeNotFoundException tne) {
            TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(type), (ImmutableList)ImmutableList.of());
            this.metadataService.createType(TypesSerialization.toJson((TypesDef)typesDef));
        }
    }

    @Override
    public String createEntity(ResourceDefinition definition, Request request) throws ResourceAlreadyExistsException {
        String typeName = definition.getTypeName();
        try {
            this.createClassType(definition, typeName, typeName + " Definition");
        }
        catch (ResourceAlreadyExistsException e) {
            // empty catch block
        }
        try {
            Referenceable entity = new Referenceable(typeName, request.getQueryProperties());
            entity.set("taxonomy.namespace", (Object)"atlas.taxonomy");
            ITypedReferenceableInstance typedInstance = this.metadataService.getTypedReferenceableInstance(entity);
            List entities = this.metadataService.createEntities(Collections.singletonList(typedInstance).toArray(new ITypedReferenceableInstance[1]));
            return entities != null && entities.size() > 0 ? (String)entities.get(0) : null;
        }
        catch (EntityExistsException e) {
            throw new ResourceAlreadyExistsException("Attempted to create an entity which already exists: " + request.getQueryProperties());
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException("An expected exception occurred creating an entity: " + (Object)((Object)e), (Exception)((Object)e));
        }
    }

    @Override
    public void deleteEntity(ResourceDefinition definition, Request request) throws ResourceNotFoundException {
        String typeName = definition.getTypeName();
        String cleanIdPropName = definition.getIdPropertyName();
        String idValue = (String)request.getProperty(cleanIdPropName);
        try {
            this.metadataService.deleteEntityByUniqueAttribute(typeName, cleanIdPropName, idValue);
        }
        catch (EntityNotFoundException e) {
            throw new ResourceNotFoundException(String.format("The specified entity doesn't exist: type=%s, %s=%s", typeName, cleanIdPropName, idValue));
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException(String.format("An unexpected error occurred while attempting to delete entity: type=%s, %s=%s : %s", new Object[]{typeName, cleanIdPropName, idValue, e}), (Exception)((Object)e));
        }
    }

    @Override
    public void createClassType(ResourceDefinition resourceDefinition, String name, String description) throws ResourceAlreadyExistsException {
        this.createType(resourceDefinition.getPropertyDefinitions(), ClassType.class, name, description, false);
    }

    @Override
    public void createTraitType(ResourceDefinition resourceDefinition, String name, String description) throws ResourceAlreadyExistsException {
        this.createType(resourceDefinition.getPropertyDefinitions(), TraitType.class, name, description, true);
    }

    @Override
    public void createTraitInstance(String guid, String typeName, Map<String, Object> properties) throws ResourceAlreadyExistsException {
        try {
            Struct struct = new Struct(typeName);
            for (Map.Entry<String, Object> propEntry : properties.entrySet()) {
                struct.set(propEntry.getKey(), propEntry.getValue());
            }
            struct.set("taxonomy.namespace", (Object)"atlas.taxonomy");
            this.metadataService.addTrait(guid, this.metadataService.createTraitInstance(struct));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("is already defined for entity")) {
                throw new ResourceAlreadyExistsException(String.format("Tag '%s' already associated with the entity", typeName));
            }
            throw e;
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException(String.format("Unable to create trait instance '%s' in type system: %s", new Object[]{typeName, e}), (Exception)((Object)e));
        }
    }

    @Override
    public void deleteTag(String guid, String traitName) throws ResourceNotFoundException {
        try {
            this.metadataService.deleteTrait(guid, traitName);
        }
        catch (TraitNotFoundException e) {
            throw new ResourceNotFoundException(String.format("The trait '%s' doesn't exist for entity '%s'", traitName, guid));
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException(String.format("Unable to delete tag '%s' from entity '%s'", traitName, guid), (Exception)((Object)e));
        }
    }

    private <T extends HierarchicalType> void createType(Collection<AttributeDefinition> attributes, Class<T> type, String name, String description, boolean isTrait) throws ResourceAlreadyExistsException {
        try {
            HierarchicalTypeDefinition definition = null;
            definition = isTrait ? new HierarchicalTypeDefinition(type, name, description, ImmutableSet.of((Object)"TaxonomyTerm"), attributes.toArray(new AttributeDefinition[attributes.size()])) : new HierarchicalTypeDefinition(type, name, description, ImmutableSet.of(), attributes.toArray(new AttributeDefinition[attributes.size()]));
            this.metadataService.createType(TypesSerialization.toJson((HierarchicalTypeDefinition)definition, (boolean)isTrait));
        }
        catch (TypeExistsException e) {
            throw new ResourceAlreadyExistsException(String.format("Type '%s' already exists", name));
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException(String.format("Unable to create type '%s' in type system: %s", new Object[]{name, e}), (Exception)((Object)e));
        }
    }
}

