/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.catalog.PropertyMapper;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.typesystem.types.FieldMapping;
import org.apache.atlas.typesystem.types.HierarchicalType;
import org.apache.atlas.typesystem.types.TypeSystem;

public class DefaultPropertyMapper
implements PropertyMapper {
    private Map<String, HierarchicalType> typeInstances = new HashMap<String, HierarchicalType>();
    private final Map<String, String> m_qualifiedToCleanMap = new HashMap<String, String>();
    private final Map<String, String> m_cleanToQualifiedMap = new HashMap<String, String>();

    public DefaultPropertyMapper() {
        this(Collections.emptyMap(), Collections.emptyMap());
    }

    public DefaultPropertyMapper(Map<String, String> qualifiedToCleanMap, Map<String, String> cleanToQualifiedMap) {
        this.setDefaultMappings();
        this.m_qualifiedToCleanMap.putAll(qualifiedToCleanMap);
        this.m_cleanToQualifiedMap.putAll(cleanToQualifiedMap);
    }

    @Override
    public String toCleanName(String propName, String type) {
        HierarchicalType dataType = this.getDataType(type);
        String replacement = this.m_qualifiedToCleanMap.get(propName);
        if (replacement == null && dataType != null) {
            String cleanName;
            FieldMapping fieldMap = dataType.fieldMapping();
            if (!fieldMap.fields.containsKey(propName) && propName.contains(".") && fieldMap.fields.containsKey(cleanName = propName.substring(propName.lastIndexOf(46) + 1))) {
                replacement = cleanName;
            }
        }
        if (replacement == null) {
            replacement = propName;
        }
        return replacement;
    }

    @Override
    public String toFullyQualifiedName(String propName, String type) {
        HierarchicalType dataType = this.getDataType(type);
        String replacement = this.m_cleanToQualifiedMap.get(propName);
        if (replacement == null && dataType != null) {
            FieldMapping fieldMap = dataType.fieldMapping();
            if (fieldMap.fields.containsKey(propName)) {
                try {
                    replacement = dataType.getQualifiedName(propName);
                }
                catch (AtlasException e) {
                    throw new CatalogRuntimeException(String.format("Unable to resolve fully qualified property name for type '%s': %s", new Object[]{type, e}), (Exception)((Object)e));
                }
            }
        }
        if (replacement == null) {
            replacement = propName;
        }
        return replacement;
    }

    protected synchronized HierarchicalType getDataType(String type) {
        HierarchicalType dataType = this.typeInstances.get(type);
        if (dataType == null) {
            dataType = this.createDataType(type);
            this.typeInstances.put(type, dataType);
        }
        return dataType;
    }

    protected HierarchicalType createDataType(String type) {
        try {
            return (HierarchicalType)TypeSystem.getInstance().getDataType(HierarchicalType.class, type);
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException("Unable to get type instance from type system for type: " + type, (Exception)((Object)e));
        }
    }

    private void setDefaultMappings() {
        this.m_qualifiedToCleanMap.put("__guid", "id");
        this.m_cleanToQualifiedMap.put("id", "__guid");
        this.m_qualifiedToCleanMap.put("__timestamp", "creation_time");
        this.m_cleanToQualifiedMap.put("creation_time", "__timestamp");
        this.m_qualifiedToCleanMap.put("__modificationTimestamp", "modified_time");
        this.m_cleanToQualifiedMap.put("modified_time", "__modificationTimestamp");
        this.m_qualifiedToCleanMap.put("__typeName", "type");
        this.m_cleanToQualifiedMap.put("type", "__typeName");
        this.m_qualifiedToCleanMap.put("__version", "version");
        this.m_cleanToQualifiedMap.put("version", "__version");
        this.m_qualifiedToCleanMap.put("__traitNames", "trait_names");
        this.m_cleanToQualifiedMap.put("trait_names", "__traitNames");
        this.m_qualifiedToCleanMap.put("__superTypeNames", "super_types");
        this.m_cleanToQualifiedMap.put("super_types", "__superTypeNames");
        this.m_qualifiedToCleanMap.put("__state", "state");
        this.m_cleanToQualifiedMap.put("state", "__state");
    }
}

