/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.query.BaseQueryExpression;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class TermRangeQueryExpression
extends BaseQueryExpression {
    private final BytesRef m_lowerTerm;
    private final BytesRef m_upperTerm;
    private final boolean m_lowerInclusive;
    private final boolean m_upperInclusive;

    public TermRangeQueryExpression(TermRangeQuery query, ResourceDefinition resourceDefinition) {
        super(query.getField(), null, resourceDefinition);
        this.m_lowerTerm = query.getLowerTerm();
        this.m_upperTerm = query.getUpperTerm();
        this.m_lowerInclusive = query.includesLower();
        this.m_upperInclusive = query.includesUpper();
    }

    @Override
    public boolean evaluate(Object value) {
        BytesRef valueBytes = new BytesRef((CharSequence)String.valueOf(value));
        return this.compareLowerBound(valueBytes) && this.compareUpperBound(valueBytes);
    }

    private boolean compareLowerBound(BytesRef valueBytes) {
        return this.m_lowerTerm == null || (this.m_lowerInclusive ? valueBytes.compareTo(this.m_lowerTerm) > 0 : valueBytes.compareTo(this.m_lowerTerm) >= 0);
    }

    private boolean compareUpperBound(BytesRef valueBytes) {
        return this.m_upperTerm == null || (this.m_upperInclusive ? valueBytes.compareTo(this.m_upperTerm) < 0 : valueBytes.compareTo(this.m_upperTerm) <= 0);
    }
}

