/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.catalog.projection.Relation;
import org.apache.atlas.catalog.query.BaseQueryExpression;
import org.apache.atlas.catalog.query.QueryExpression;
import org.apache.atlas.catalog.query.QueryFactory;

public class ProjectionQueryExpression
extends BaseQueryExpression {
    private final QueryExpression underlyingExpression;
    private final ResourceDefinition resourceDefinition;
    private final String[] fieldSegments;

    protected ProjectionQueryExpression(QueryExpression underlyingExpression, ResourceDefinition resourceDefinition) {
        super(underlyingExpression.getField(), underlyingExpression.getExpectedValue(), resourceDefinition);
        this.underlyingExpression = underlyingExpression;
        this.resourceDefinition = resourceDefinition;
        this.fieldSegments = this.getField().split("__slash__");
    }

    @Override
    public Pipe asPipe() {
        int sepIdx = this.getField().indexOf("__slash__");
        String edgeToken = this.getField().substring(0, sepIdx);
        GremlinPipeline pipeline = new GremlinPipeline();
        Relation relation = this.resourceDefinition.getRelations().get(this.fieldSegments[0]);
        if (relation != null) {
            pipeline = pipeline.outE(new String[0]);
            pipeline.add(relation.asPipe()).inV();
        } else {
            if (this.resourceDefinition.getProjections().get(this.fieldSegments[0]) != null) {
                return super.asPipe();
            }
            pipeline = pipeline.outE(new String[0]).has("label", (Predicate)Text.REGEX, (Object)String.format(".*\\.%s", edgeToken)).inV();
        }
        String childFieldName = this.getField().substring(sepIdx + "__slash__".length());
        this.underlyingExpression.setField(childFieldName);
        Pipe childPipe = childFieldName.contains("__slash__") ? new ProjectionQueryExpression(this.underlyingExpression, this.resourceDefinition).asPipe() : this.underlyingExpression.asPipe();
        pipeline.add(childPipe);
        return this.negate ? new FilterFunctionPipe((PipeFunction)new ExcludePipeFunction(pipeline)) : pipeline;
    }

    @Override
    public boolean evaluate(VertexWrapper vWrapper) {
        boolean result = false;
        Iterator<ProjectionResult> projectionIterator = this.resourceDefinition.getProjections().get(this.fieldSegments[0]).values(vWrapper).iterator();
        block0: while (!result && projectionIterator.hasNext()) {
            ProjectionResult projectionResult = projectionIterator.next();
            for (Map<String, Object> propertyMap : projectionResult.getPropertyMaps()) {
                Object val = propertyMap.get(this.fieldSegments[1]);
                if (val == null || !this.underlyingExpression.evaluate(QueryFactory.escape(val))) continue;
                result = true;
                continue block0;
            }
        }
        return this.negate ^ result;
    }

    protected QueryExpression getUnderlyingExpression() {
        return this.underlyingExpression;
    }

    private static class ExcludePipeFunction
    implements PipeFunction<Object, Boolean> {
        private final GremlinPipeline excludePipeline;

        public ExcludePipeFunction(GremlinPipeline excludePipeline) {
            this.excludePipeline = excludePipeline;
        }

        public Boolean compute(Object vertices) {
            GremlinPipeline p = new GremlinPipeline(Collections.singleton(vertices));
            p.add((Pipe)this.excludePipeline);
            return p.gather().toList().isEmpty();
        }
    }
}

