/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import java.util.Collection;
import java.util.HashSet;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.query.QueryExpression;

public abstract class BaseQueryExpression
implements QueryExpression {
    protected String m_field;
    protected final String m_expectedValue;
    protected final ResourceDefinition resourceDefinition;
    protected boolean negate = false;
    protected Collection<String> properties = new HashSet<String>();

    protected BaseQueryExpression(String field, String expectedValue, ResourceDefinition resourceDefinition) {
        this.m_field = field;
        if (field != null) {
            this.properties.add(field);
        }
        this.m_expectedValue = expectedValue;
        this.resourceDefinition = resourceDefinition;
    }

    @Override
    public boolean evaluate(VertexWrapper vWrapper) {
        return this.negate ^ this.evaluate(vWrapper.getProperty(this.m_field));
    }

    @Override
    public Collection<String> getProperties() {
        return this.properties;
    }

    @Override
    public boolean evaluate(Object value) {
        return false;
    }

    @Override
    public Pipe asPipe() {
        return new FilterFunctionPipe((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex vertex) {
                return BaseQueryExpression.this.evaluate(new VertexWrapper(vertex, BaseQueryExpression.this.resourceDefinition));
            }
        });
    }

    @Override
    public String getField() {
        return this.m_field;
    }

    @Override
    public String getExpectedValue() {
        return this.m_expectedValue;
    }

    @Override
    public void setField(String field) {
        this.m_field = field;
    }

    @Override
    public void setNegate() {
        this.negate = true;
    }

    @Override
    public boolean isNegate() {
        return this.negate;
    }

    @Override
    public boolean isProjectionExpression() {
        return this.getField() != null && this.getField().contains("__slash__");
    }
}

