/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.query;

import com.thinkaurelius.titan.core.TitanGraph;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.catalog.query.AtlasQuery;
import org.apache.atlas.catalog.query.QueryExpression;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.atlas.typesystem.persistence.Id;

public abstract class BaseQuery
implements AtlasQuery {
    protected final QueryExpression queryExpression;
    protected final ResourceDefinition resourceDefinition;
    protected final Request request;

    public BaseQuery(QueryExpression queryExpression, ResourceDefinition resourceDefinition, Request request) {
        this.queryExpression = queryExpression;
        this.resourceDefinition = resourceDefinition;
        this.request = request;
    }

    @Override
    public Collection<Map<String, Object>> execute() throws ResourceNotFoundException {
        ArrayList<Map<String, Object>> resultMaps = new ArrayList<Map<String, Object>>();
        try {
            for (Vertex vertex : this.executeQuery()) {
                resultMaps.add(this.processPropertyMap(this.wrapVertex(vertex)));
            }
            this.getGraph().commit();
        }
        catch (Throwable t) {
            this.getGraph().rollback();
            throw t;
        }
        return resultMaps;
    }

    @Override
    public Collection<Map<String, Object>> execute(Map<String, Object> updateProperties) throws ResourceNotFoundException {
        ArrayList<Map<String, Object>> resultMaps = new ArrayList<Map<String, Object>>();
        try {
            for (Vertex vertex : this.executeQuery()) {
                VertexWrapper vWrapper = this.wrapVertex(vertex);
                for (Map.Entry<String, Object> property : updateProperties.entrySet()) {
                    vWrapper.setProperty(property.getKey(), property.getValue());
                    vWrapper.setProperty("__modificationTimestamp", System.currentTimeMillis());
                }
                resultMaps.add(this.processPropertyMap(vWrapper));
            }
            this.getGraph().commit();
        }
        catch (Throwable e) {
            this.getGraph().rollback();
            throw e;
        }
        return resultMaps;
    }

    private List<Vertex> executeQuery() {
        GremlinPipeline pipeline = this.buildPipeline().as("root");
        Pipe expressionPipe = this.queryExpression.asPipe();
        return expressionPipe == null ? pipeline.toList() : pipeline.add(expressionPipe).back("root").toList();
    }

    protected GremlinPipeline buildPipeline() {
        GremlinPipeline pipeline = this.getRootVertexPipeline();
        Pipe queryPipe = this.getQueryPipe();
        if (queryPipe != null) {
            pipeline.add(queryPipe);
        }
        pipeline.add(this.getNotDeletedPipe());
        return pipeline;
    }

    protected abstract Pipe getQueryPipe();

    protected GremlinPipeline getRootVertexPipeline() {
        return new GremlinPipeline((Object)this.getGraph().getVertices());
    }

    protected Pipe getNotDeletedPipe() {
        return new PropertyFilterPipe("__state", (Predicate)Compare.EQUAL, (Object)Id.EntityState.ACTIVE.name());
    }

    protected Map<String, Object> processPropertyMap(VertexWrapper vertex) {
        Map<String, Object> propertyMap = this.resourceDefinition.filterProperties(this.request, vertex.getPropertyMap());
        this.addHref(vertex, propertyMap);
        return this.request.getCardinality() == Request.Cardinality.INSTANCE ? this.applyProjections(vertex, propertyMap) : propertyMap;
    }

    protected void addHref(VertexWrapper vWrapper, Map<String, Object> filteredPropertyMap) {
        String href = this.resourceDefinition.resolveHref(filteredPropertyMap);
        if (href != null) {
            filteredPropertyMap.put("href", href);
        }
    }

    protected Map<String, Object> applyProjections(VertexWrapper vertex, Map<String, Object> propertyMap) {
        for (Projection p : this.resourceDefinition.getProjections().values()) {
            for (ProjectionResult projectionResult : p.values(vertex)) {
                if (p.getCardinality() == Projection.Cardinality.MULTIPLE) {
                    propertyMap.put(projectionResult.getName(), projectionResult.getPropertyMaps());
                    continue;
                }
                for (Map<String, Object> projectionMap : projectionResult.getPropertyMaps()) {
                    propertyMap.put(projectionResult.getName(), projectionMap);
                }
            }
        }
        return propertyMap;
    }

    protected QueryExpression getQueryExpression() {
        return this.queryExpression;
    }

    protected ResourceDefinition getResourceDefinition() {
        return this.resourceDefinition;
    }

    protected Request getRequest() {
        return this.request;
    }

    protected TitanGraph getGraph() {
        return TitanGraphProvider.getGraphInstance();
    }

    protected VertexWrapper wrapVertex(Vertex v) {
        return new VertexWrapper(v, this.resourceDefinition);
    }
}

