/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.projection;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.atlas.catalog.ResourceComparator;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.catalog.projection.Relation;
import org.apache.atlas.catalog.projection.RelationSet;

public class RelationProjection
extends Projection {
    private Relation relation;

    public RelationProjection(String name, final Collection<String> fields, final Relation relation, Projection.Cardinality cardinality) {
        super(name, cardinality, (Pipe<VertexWrapper, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<VertexWrapper, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(VertexWrapper start) {
                ArrayList<ProjectionResult> projectionResults = new ArrayList<ProjectionResult>();
                for (RelationSet relationSet : relation.traverse(start)) {
                    ArrayList<Map<String, Object>> propertyMaps = new ArrayList<Map<String, Object>>();
                    for (VertexWrapper vWrapper : relationSet.getVertices()) {
                        TreeMap propertyMap = new TreeMap(new ResourceComparator());
                        propertyMaps.add(propertyMap);
                        if (fields.isEmpty()) {
                            for (String property : vWrapper.getPropertyKeys()) {
                                propertyMap.put(property, vWrapper.getProperty(property));
                            }
                            continue;
                        }
                        for (String property : fields) {
                            propertyMap.put(property, vWrapper.getProperty(property));
                        }
                    }
                    projectionResults.add(new ProjectionResult(relationSet.getName(), start, propertyMaps));
                }
                return projectionResults;
            }
        }));
        this.relation = relation;
    }

    public Relation getRelation() {
        return this.relation;
    }
}

