/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.projection;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.pipes.Pipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.projection.BaseRelation;
import org.apache.atlas.catalog.projection.RelationSet;

public class GenericRelation
extends BaseRelation {
    private final ResourceDefinition resourceDefinition;

    public GenericRelation(ResourceDefinition resourceDefinition) {
        this.resourceDefinition = resourceDefinition;
    }

    @Override
    public Collection<RelationSet> traverse(VertexWrapper vWrapper) {
        ArrayList<RelationSet> relations = new ArrayList<RelationSet>();
        Vertex v = vWrapper.getVertex();
        String vertexType = (String)v.getProperty("__typeName");
        HashMap<String, ArrayList<VertexWrapper>> vertexMap = new HashMap<String, ArrayList<VertexWrapper>>();
        for (Edge edge : v.getEdges(Direction.OUT, new String[0])) {
            Vertex adjacentVertex;
            String edgePrefix;
            String edgeLabel = edge.getLabel();
            if (!edgeLabel.startsWith(edgePrefix = String.format("%s%s.", "__", vertexType)) || this.isDeleted(adjacentVertex = edge.getVertex(Direction.IN))) continue;
            VertexWrapper relationVertex = new VertexWrapper(adjacentVertex, this.resourceDefinition);
            String relationName = edgeLabel.substring(edgePrefix.length());
            ArrayList<VertexWrapper> vertices = (ArrayList<VertexWrapper>)vertexMap.get(relationName);
            if (vertices == null) {
                vertices = new ArrayList<VertexWrapper>();
                vertexMap.put(relationName, vertices);
            }
            vertices.add(relationVertex);
        }
        for (Map.Entry entry : vertexMap.entrySet()) {
            relations.add(new RelationSet((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return relations;
    }

    @Override
    public Pipe asPipe() {
        return null;
    }

    @Override
    public ResourceDefinition getResourceDefinition() {
        return this.resourceDefinition;
    }
}

