/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.definition;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceComparator;
import org.apache.atlas.catalog.TermPath;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.BaseResourceDefinition;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.utils.TypesUtil;

public class TermResourceDefinition
extends BaseResourceDefinition {
    public TermResourceDefinition() {
        this.registerProperty(TypesUtil.createRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE));
        this.registerProperty(TypesUtil.createOptionalAttrDef((String)"description", (IDataType)DataTypes.STRING_TYPE));
        this.registerProperty(TypesUtil.createOptionalAttrDef((String)"available_as_tag", (IDataType)DataTypes.BOOLEAN_TYPE));
        this.registerProperty(TypesUtil.createOptionalAttrDef((String)"acceptable_use", (IDataType)DataTypes.STRING_TYPE));
        this.instanceProperties.add("name");
        this.instanceProperties.add("description");
        this.instanceProperties.add("creation_time");
        this.instanceProperties.add("available_as_tag");
        this.instanceProperties.add("acceptable_use");
        this.collectionProperties.add("name");
        this.collectionProperties.add("description");
        this.projections.put("terms", this.getSubTermProjection());
        this.projections.put("hierarchy", this.getHierarchyProjection());
    }

    @Override
    public void validateCreatePayload(Request request) throws InvalidPayloadException {
        super.validateCreatePayload(request);
        String name = (String)request.getProperty("name");
        if (!name.contains(".")) {
            throw new InvalidPayloadException("Term name must be in the form 'taxonomyName.termName.subTermName'");
        }
        if (!request.getQueryProperties().containsKey("available_as_tag")) {
            request.getQueryProperties().put("available_as_tag", true);
        }
    }

    @Override
    public String getTypeName() {
        return "Term";
    }

    @Override
    public String getIdPropertyName() {
        return "name";
    }

    @Override
    public String resolveHref(Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append("v1/taxonomies/");
        TermPath termPath = new TermPath(String.valueOf(properties.get("name")));
        String[] paths = termPath.getPathSegments();
        sb.append(termPath.getTaxonomyName());
        for (String path : paths) {
            if (path == null || path.isEmpty()) continue;
            sb.append("/terms/");
            sb.append(path);
        }
        return sb.toString();
    }

    private Projection getHierarchyProjection() {
        String projectionName = "hierarchy";
        return new Projection("hierarchy", Projection.Cardinality.SINGLE, (Pipe<VertexWrapper, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<VertexWrapper, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(VertexWrapper start) {
                TreeMap<String, String> map = new TreeMap<String, String>(new ResourceComparator());
                TermPath termPath = new TermPath((String)start.getVertex().getProperty("__typeName"));
                map.put("path", termPath.getPath());
                map.put("short_name", termPath.getShortName());
                map.put("taxonomy", termPath.getTaxonomyName());
                return Collections.singleton(new ProjectionResult("hierarchy", start, Collections.singleton(map)));
            }
        }));
    }

    private Projection getSubTermProjection() {
        String termsProjectionName = "terms";
        return new Projection("terms", Projection.Cardinality.SINGLE, (Pipe<VertexWrapper, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<VertexWrapper, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(VertexWrapper start) {
                TreeMap<String, String> map = new TreeMap<String, String>(new ResourceComparator());
                StringBuilder sb = new StringBuilder();
                sb.append("v1/taxonomies/");
                TermPath termPath = new TermPath((String)start.getVertex().getProperty("__typeName"));
                String[] paths = termPath.getPathSegments();
                sb.append(termPath.getTaxonomyName());
                for (String path : paths) {
                    if (path == null || path.isEmpty()) continue;
                    sb.append("/terms/");
                    sb.append(path);
                }
                sb.append("/terms");
                map.put("href", sb.toString());
                return Collections.singleton(new ProjectionResult("terms", start, Collections.singleton(map)));
            }
        }));
    }
}

