/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.definition;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.atlas.catalog.DefaultPropertyMapper;
import org.apache.atlas.catalog.PropertyMapper;
import org.apache.atlas.catalog.ResourceComparator;
import org.apache.atlas.catalog.VertexWrapper;
import org.apache.atlas.catalog.definition.BaseResourceDefinition;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.utils.TypesUtil;

public class EntityTagResourceDefinition
extends BaseResourceDefinition {
    public static final String ENTITY_GUID_PROPERTY = "entity-guid";

    public EntityTagResourceDefinition() {
        this.registerProperty(TypesUtil.createRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE));
        this.instanceProperties.add("name");
        this.instanceProperties.add("description");
        this.instanceProperties.add("creation_time");
        this.collectionProperties.add("name");
        this.collectionProperties.add("description");
        this.projections.put("terms", this.getTermProjection());
    }

    @Override
    public String getIdPropertyName() {
        return "name";
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public String resolveHref(Map<String, Object> properties) {
        return String.format("v1/entities/%s/tags/%s", properties.get(ENTITY_GUID_PROPERTY), properties.get("name"));
    }

    private Projection getTermProjection() {
        return new Projection("term", Projection.Cardinality.SINGLE, (Pipe<VertexWrapper, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<VertexWrapper, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(VertexWrapper start) {
                TreeMap<String, String> map = new TreeMap<String, String>(new ResourceComparator());
                StringBuilder sb = new StringBuilder();
                sb.append("v1/taxonomies/");
                String fullyQualifiedName = (String)start.getVertex().getProperty("__typeName");
                String[] paths = fullyQualifiedName.split("\\.");
                sb.append(paths[0]);
                for (int i = 1; i < paths.length; ++i) {
                    String path = paths[i];
                    if (path == null || path.isEmpty()) continue;
                    sb.append("/terms/");
                    sb.append(path);
                }
                map.put("href", sb.toString());
                return Collections.singleton(new ProjectionResult("term", start, Collections.singleton(map)));
            }
        }));
    }

    @Override
    protected PropertyMapper createPropertyMapper() {
        return new DefaultPropertyMapper(Collections.singletonMap("__typeName", "name"), Collections.singletonMap("name", "__typeName"));
    }
}

