/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.definition;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.definition.BaseResourceDefinition;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.projection.GenericRelation;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.ProjectionResult;
import org.apache.atlas.catalog.projection.RelationProjection;
import org.apache.atlas.catalog.projection.TagRelation;
import org.apache.atlas.catalog.projection.TraitRelation;

public class EntityResourceDefinition
extends BaseResourceDefinition {
    public EntityResourceDefinition() {
        this.collectionProperties.add("name");
        this.collectionProperties.add("id");
        this.collectionProperties.add("type");
        RelationProjection tagProjection = this.getTagProjection();
        this.projections.put("tags", tagProjection);
        RelationProjection traitProjection = this.getTraitProjection();
        this.projections.put("traits", traitProjection);
        this.projections.put("default", this.getDefaultRelationProjection());
        this.relations.put(tagProjection.getName(), tagProjection.getRelation());
        this.relations.put(traitProjection.getName(), traitProjection.getRelation());
    }

    @Override
    public String getIdPropertyName() {
        return "id";
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public void validateCreatePayload(Request request) throws InvalidPayloadException {
    }

    @Override
    public String resolveHref(Map<String, Object> properties) {
        Object id = properties.get("id");
        return id == null ? null : String.format("v1/entities/%s", id);
    }

    private RelationProjection getTagProjection() {
        TagRelation traitRelation = new TagRelation();
        RelationProjection tagProjection = new RelationProjection("tags", Collections.singleton("name"), traitRelation, Projection.Cardinality.MULTIPLE);
        tagProjection.addPipe((Pipe<Collection<ProjectionResult>, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<Collection<ProjectionResult>, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(Collection<ProjectionResult> results) {
                for (ProjectionResult result : results) {
                    for (Map<String, Object> properties : result.getPropertyMaps()) {
                        properties.put("href", String.format("v1/entities/%s/tags/%s", result.getStartingVertex().getProperty("id"), properties.get("name")));
                    }
                }
                return results;
            }
        }));
        return tagProjection;
    }

    private RelationProjection getTraitProjection() {
        return new RelationProjection("traits", Collections.emptySet(), new TraitRelation(), Projection.Cardinality.MULTIPLE);
    }

    private RelationProjection getDefaultRelationProjection() {
        GenericRelation genericRelation = new GenericRelation(this);
        RelationProjection relationProjection = new RelationProjection("relations", Arrays.asList("type", "id", "name"), genericRelation, Projection.Cardinality.MULTIPLE);
        relationProjection.addPipe((Pipe<Collection<ProjectionResult>, Collection<ProjectionResult>>)new TransformFunctionPipe((PipeFunction)new PipeFunction<Collection<ProjectionResult>, Collection<ProjectionResult>>(){

            public Collection<ProjectionResult> compute(Collection<ProjectionResult> results) {
                for (ProjectionResult result : results) {
                    for (Map<String, Object> properties : result.getPropertyMaps()) {
                        properties.put("href", String.format("v1/entities/%s", properties.get("id")));
                    }
                }
                return results;
            }
        }));
        return relationProjection;
    }
}

