/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog.definition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasException;
import org.apache.atlas.catalog.DefaultDateFormatter;
import org.apache.atlas.catalog.DefaultPropertyMapper;
import org.apache.atlas.catalog.PropertyMapper;
import org.apache.atlas.catalog.PropertyValueFormatter;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.projection.Projection;
import org.apache.atlas.catalog.projection.Relation;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.AttributeInfo;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;

public abstract class BaseResourceDefinition
implements ResourceDefinition {
    protected static final TypeSystem typeSystem = TypeSystem.getInstance();
    protected final Set<String> instanceProperties = new HashSet<String>();
    protected final Set<String> collectionProperties = new HashSet<String>();
    protected Map<String, AttributeDefinition> propertyDefs = new HashMap<String, AttributeDefinition>();
    protected Map<String, AttributeInfo> properties = new HashMap<String, AttributeInfo>();
    protected final Map<String, Projection> projections = new HashMap<String, Projection>();
    protected final Map<String, Relation> relations = new HashMap<String, Relation>();
    protected final PropertyMapper propertyMapper;
    protected final Map<String, PropertyValueFormatter> propertyValueFormatters = new HashMap<String, PropertyValueFormatter>();

    public BaseResourceDefinition() {
        DefaultDateFormatter defaultDateFormatter = new DefaultDateFormatter();
        this.registerPropertyValueFormatter("creation_time", defaultDateFormatter);
        this.registerPropertyValueFormatter("modified_time", defaultDateFormatter);
        this.propertyMapper = this.createPropertyMapper();
    }

    @Override
    public void validateCreatePayload(Request request) throws InvalidPayloadException {
        HashSet<String> propKeys = new HashSet<String>(request.getQueryProperties().keySet());
        HashSet<String> missingProperties = new HashSet<String>();
        for (AttributeInfo property : this.properties.values()) {
            String name = property.name;
            if (property.multiplicity == Multiplicity.REQUIRED && request.getProperty(name) == null) {
                missingProperties.add(name);
            }
            propKeys.remove(name);
        }
        if (!missingProperties.isEmpty() || !propKeys.isEmpty()) {
            throw new InvalidPayloadException(missingProperties, propKeys);
        }
    }

    @Override
    public void validateUpdatePayload(Request request) throws InvalidPayloadException {
        HashSet<String> updateKeys = new HashSet<String>(request.getUpdateProperties().keySet());
        HashSet<String> validProperties = new HashSet<String>(this.properties.keySet());
        validProperties.remove("name");
        updateKeys.removeAll(validProperties);
        if (!updateKeys.isEmpty()) {
            throw new InvalidPayloadException(Collections.emptySet(), updateKeys);
        }
    }

    @Override
    public Collection<AttributeDefinition> getPropertyDefinitions() {
        return this.propertyDefs.values();
    }

    @Override
    public Map<String, Object> filterProperties(Request request, Map<String, Object> propertyMap) {
        Request.Cardinality cardinality = request.getCardinality();
        Collection<String> requestProperties = request.getAdditionalSelectProperties();
        Iterator<Map.Entry<String, Object>> propIter = propertyMap.entrySet().iterator();
        while (propIter.hasNext()) {
            Map.Entry<String, Object> propEntry = propIter.next();
            String prop = propEntry.getKey();
            if (requestProperties.contains(prop)) continue;
            if (cardinality == Request.Cardinality.COLLECTION) {
                if (this.collectionProperties.contains(prop)) continue;
                propIter.remove();
                continue;
            }
            if (this.instanceProperties.isEmpty() || this.instanceProperties.contains(prop)) continue;
            propIter.remove();
        }
        return propertyMap;
    }

    @Override
    public Map<String, Projection> getProjections() {
        return this.projections;
    }

    @Override
    public Map<String, Relation> getRelations() {
        return this.relations;
    }

    @Override
    public synchronized PropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    @Override
    public Map<String, PropertyValueFormatter> getPropertyValueFormatters() {
        return this.propertyValueFormatters;
    }

    protected void registerProperty(AttributeDefinition propertyDefinition) {
        try {
            this.propertyDefs.put(propertyDefinition.name, propertyDefinition);
            this.properties.put(propertyDefinition.name, new AttributeInfo(typeSystem, propertyDefinition, null));
        }
        catch (AtlasException e) {
            throw new CatalogRuntimeException("Unable to create attribute: " + propertyDefinition.name, (Exception)((Object)e));
        }
    }

    protected void registerPropertyValueFormatter(String property, PropertyValueFormatter valueFormatter) {
        this.propertyValueFormatters.put(property, valueFormatter);
    }

    protected PropertyMapper createPropertyMapper() {
        return new DefaultPropertyMapper();
    }
}

