/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.atlas.catalog.PropertyMapper;
import org.apache.atlas.catalog.PropertyValueFormatter;
import org.apache.atlas.catalog.ResourceComparator;
import org.apache.atlas.catalog.definition.ResourceDefinition;

public class VertexWrapper {
    private final Vertex vertex;
    private final String vertexType;
    private final Set<String> removedProperties = new HashSet<String>();
    private final PropertyMapper propertyMapper;
    private final Map<String, PropertyValueFormatter> propertyValueFormatters;
    protected ResourceComparator resourceComparator = new ResourceComparator();

    public VertexWrapper(Vertex v, ResourceDefinition resourceDefinition) {
        this(v, resourceDefinition.getPropertyMapper(), resourceDefinition.getPropertyValueFormatters());
    }

    public VertexWrapper(Vertex v, PropertyMapper mapper, Map<String, PropertyValueFormatter> formatters) {
        this.vertex = v;
        this.vertexType = this.getVertexType(v);
        this.propertyMapper = mapper;
        this.propertyValueFormatters = formatters;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public <T> T getProperty(String name) {
        Object val;
        if (this.removedProperties.contains(name)) {
            val = null;
        } else {
            val = this.vertex.getProperty(this.propertyMapper.toFullyQualifiedName(name, this.vertexType));
            if (this.propertyValueFormatters.containsKey(name)) {
                val = this.propertyValueFormatters.get(name).format(val);
            }
        }
        return (T)val;
    }

    public void setProperty(String name, Object value) {
        this.vertex.setProperty(this.propertyMapper.toFullyQualifiedName(name, this.vertexType), value);
    }

    public Collection<String> getPropertyKeys() {
        TreeSet<String> propertyKeys = new TreeSet<String>(this.resourceComparator);
        for (String p : this.vertex.getPropertyKeys()) {
            String cleanName = this.propertyMapper.toCleanName(p, this.vertexType);
            if (this.removedProperties.contains(cleanName)) continue;
            propertyKeys.add(cleanName);
        }
        return propertyKeys;
    }

    public Map<String, Object> getPropertyMap() {
        TreeMap<String, Object> props = new TreeMap<String, Object>(this.resourceComparator);
        for (String p : this.vertex.getPropertyKeys()) {
            String cleanName = this.propertyMapper.toCleanName(p, this.vertexType);
            if (this.removedProperties.contains(cleanName)) continue;
            Object val = this.vertex.getProperty(p);
            if (this.propertyValueFormatters.containsKey(cleanName)) {
                val = this.propertyValueFormatters.get(cleanName).format(val);
            }
            props.put(cleanName, val);
        }
        return props;
    }

    public void removeProperty(String name) {
        this.removedProperties.add(name);
    }

    public boolean isPropertyRemoved(String name) {
        return this.removedProperties.contains(name);
    }

    public String toString() {
        return String.format("VertexWrapper[name=%s]", this.getProperty("name"));
    }

    private String getVertexType(Vertex v) {
        return (String)v.getProperty("__typeName");
    }
}

