/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.BaseResourceProvider;
import org.apache.atlas.catalog.CollectionRequest;
import org.apache.atlas.catalog.EntityResourceProvider;
import org.apache.atlas.catalog.EntityTagResourceProvider;
import org.apache.atlas.catalog.InstanceRequest;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceProvider;
import org.apache.atlas.catalog.Result;
import org.apache.atlas.catalog.TaxonomyResourceProvider;
import org.apache.atlas.catalog.TermPath;
import org.apache.atlas.catalog.definition.TermResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.exception.InvalidQueryException;
import org.apache.atlas.catalog.exception.ResourceAlreadyExistsException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.query.AtlasQuery;

public class TermResourceProvider
extends BaseResourceProvider
implements ResourceProvider {
    private ResourceProvider taxonomyResourceProvider;
    private ResourceProvider entityResourceProvider;
    private ResourceProvider entityTagResourceProvider;

    public TermResourceProvider(AtlasTypeSystem typeSystem) {
        super(typeSystem, new TermResourceDefinition());
    }

    @Override
    public Result getResourceById(Request request) throws ResourceNotFoundException {
        AtlasQuery atlasQuery;
        request.getQueryProperties().put("name", ((TermPath)request.getProperty("termPath")).getFullyQualifiedName());
        try {
            atlasQuery = this.queryFactory.createTermQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Term query: " + e, e);
        }
        Collection<Map<String, Object>> results = atlasQuery.execute();
        if (results.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Term '%s' not found.", ((TermPath)request.getProperty("termPath")).getFullyQualifiedName()));
        }
        return new Result(results);
    }

    @Override
    public Result getResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        TermPath termPath = (TermPath)request.getProperty("termPath");
        String queryString = this.doQueryStringConversions(termPath, request.getQueryString());
        CollectionRequest queryRequest = new CollectionRequest(request.getQueryProperties(), queryString);
        AtlasQuery atlasQuery = this.queryFactory.createTermQuery(queryRequest);
        Collection<Map<String, Object>> result = atlasQuery.execute();
        return new Result(result);
    }

    @Override
    public void createResource(Request request) throws InvalidPayloadException, ResourceAlreadyExistsException, ResourceNotFoundException {
        TermPath termPath = (TermPath)request.getQueryProperties().remove("termPath");
        String qualifiedTermName = termPath.getFullyQualifiedName();
        request.getQueryProperties().put("name", qualifiedTermName);
        this.resourceDefinition.validateCreatePayload(request);
        InstanceRequest taxonomyRequest = new InstanceRequest(Collections.singletonMap("name", termPath.getTaxonomyName()));
        taxonomyRequest.addAdditionalSelectProperties(Collections.singleton("id"));
        Result taxonomyResult = this.getTaxonomyResourceProvider().getResourceById(taxonomyRequest);
        Map<String, Object> taxonomyPropertyMap = taxonomyResult.getPropertyMaps().iterator().next();
        if (!termPath.getPath().equals("/")) {
            HashMap<String, Object> parentProperties = new HashMap<String, Object>(request.getQueryProperties());
            parentProperties.put("termPath", termPath.getParent());
            this.getResourceById(new InstanceRequest(parentProperties));
        }
        this.typeSystem.createTraitType(this.resourceDefinition, qualifiedTermName, (String)request.getProperty("description"));
        this.typeSystem.createTraitInstance(String.valueOf(taxonomyPropertyMap.get("id")), qualifiedTermName, request.getQueryProperties());
    }

    @Override
    public Collection<String> createResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        throw new UnsupportedOperationException("Creating multiple Terms in a request is not currently supported");
    }

    @Override
    public void updateResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        AtlasQuery atlasQuery;
        this.resourceDefinition.validateUpdatePayload(request);
        String termName = ((TermPath)request.getProperty("termPath")).getFullyQualifiedName();
        request.getQueryProperties().put("name", termName);
        try {
            atlasQuery = this.queryFactory.createTermQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Term query: " + e, e);
        }
        Map<String, Object> updateProperties = request.getUpdateProperties();
        Collection<Map<String, Object>> results = atlasQuery.execute(updateProperties);
        if (results.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Term '%s' not found.", termName));
        }
        if (updateProperties.containsKey("description")) {
            AtlasQuery tagQuery;
            String tagQueryString = String.format("name:%s", termName);
            CollectionRequest tagRequest = new CollectionRequest(Collections.singletonMap("id", "*"), tagQueryString, null);
            try {
                tagQuery = this.queryFactory.createEntityTagQuery(tagRequest);
            }
            catch (InvalidQueryException e) {
                throw new CatalogRuntimeException("Unable to compile internal Entity Tag query: " + e, e);
            }
            tagQuery.execute(Collections.singletonMap("description", updateProperties.get("description")));
        }
    }

    @Override
    public void deleteResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        this.getResourceById(request);
        TermPath termPath = (TermPath)request.getQueryProperties().get("termPath");
        String taxonomyId = this.getTaxonomyId(termPath);
        this.deleteChildren(taxonomyId, termPath);
        this.deleteTerm(taxonomyId, termPath);
    }

    protected void deleteChildren(String taxonomyId, TermPath termPath) throws ResourceNotFoundException, InvalidPayloadException {
        AtlasQuery collectionQuery;
        TermPath collectionTermPath = new TermPath(termPath.getFullyQualifiedName() + ".");
        CollectionRequest queryRequest = new CollectionRequest(Collections.singletonMap("termPath", collectionTermPath), null);
        try {
            collectionQuery = this.queryFactory.createTermQuery(queryRequest);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Failed to compile internal predicate: " + e, e);
        }
        Collection<Map<String, Object>> children = collectionQuery.execute();
        for (Map<String, Object> childMap : children) {
            this.deleteTerm(taxonomyId, new TermPath(String.valueOf(childMap.get("name"))));
        }
    }

    private void deleteTerm(String taxonomyId, TermPath termPath) throws ResourceNotFoundException, InvalidPayloadException {
        String fullyQualifiedName = termPath.getFullyQualifiedName();
        this.deleteEntityTagsForTerm(fullyQualifiedName);
        this.typeSystem.deleteTag(taxonomyId, fullyQualifiedName);
    }

    private void deleteEntityTagsForTerm(String fullyQualifiedName) throws ResourceNotFoundException {
        Result entityResult;
        String entityQueryStr = String.format("tags/name:%s", fullyQualifiedName);
        CollectionRequest entityRequest = new CollectionRequest(Collections.emptyMap(), entityQueryStr);
        try {
            entityResult = this.getEntityResourceProvider().getResources(entityRequest);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException(String.format("Failed to compile internal predicate for query '%s': %s", entityQueryStr, e), e);
        }
        for (Map<String, Object> entityResultMap : entityResult.getPropertyMaps()) {
            HashMap<String, Object> tagRequestProperties = new HashMap<String, Object>();
            tagRequestProperties.put("id", String.valueOf(entityResultMap.get("id")));
            tagRequestProperties.put("name", fullyQualifiedName);
            try {
                this.getEntityTagResourceProvider().deleteResourceById(new InstanceRequest(tagRequestProperties));
            }
            catch (InvalidPayloadException e) {
                throw new CatalogRuntimeException("An internal error occurred while trying to delete an entity tag: " + e, e);
            }
        }
    }

    private String getTaxonomyId(TermPath termPath) throws ResourceNotFoundException {
        InstanceRequest taxonomyRequest = new InstanceRequest(Collections.singletonMap("name", termPath.getTaxonomyName()));
        taxonomyRequest.addAdditionalSelectProperties(Collections.singleton("id"));
        Result taxonomyResult = this.getTaxonomyResourceProvider().getResourceById(taxonomyRequest);
        Map<String, Object> taxonomyResultMap = taxonomyResult.getPropertyMaps().iterator().next();
        return String.valueOf(taxonomyResultMap.get("id"));
    }

    private String doQueryStringConversions(TermPath termPath, String queryStr) throws InvalidQueryException {
        String hierarchyPathProp = "hierarchy/path";
        if (queryStr != null && queryStr.contains(String.format("%s:.", hierarchyPathProp))) {
            queryStr = queryStr.replaceAll(String.format("%s:.", hierarchyPathProp), String.format("%s:%s", hierarchyPathProp, termPath.getPath()));
        }
        return queryStr;
    }

    protected synchronized ResourceProvider getTaxonomyResourceProvider() {
        if (this.taxonomyResourceProvider == null) {
            this.taxonomyResourceProvider = new TaxonomyResourceProvider(this.typeSystem);
        }
        return this.taxonomyResourceProvider;
    }

    protected synchronized ResourceProvider getEntityResourceProvider() {
        if (this.entityResourceProvider == null) {
            this.entityResourceProvider = new EntityResourceProvider(this.typeSystem);
        }
        return this.entityResourceProvider;
    }

    protected synchronized ResourceProvider getEntityTagResourceProvider() {
        if (this.entityTagResourceProvider == null) {
            this.entityTagResourceProvider = new EntityTagResourceProvider(this.typeSystem);
        }
        return this.entityTagResourceProvider;
    }
}

