/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

public class TermPath {
    private final String m_taxonomy;
    private final String m_fqn;
    private final String m_name;
    private final String[] m_paths;

    public TermPath(String fullyQualifiedName) {
        this.m_fqn = fullyQualifiedName;
        int idx = fullyQualifiedName.indexOf(46);
        if (idx != -1) {
            this.m_taxonomy = fullyQualifiedName.substring(0, idx);
            this.m_name = fullyQualifiedName.substring(idx + 1);
            this.m_paths = this.m_name.split("\\.");
        } else {
            this.m_taxonomy = fullyQualifiedName;
            this.m_name = null;
            this.m_paths = new String[0];
        }
    }

    public TermPath(String taxonomyName, String termName) {
        this.m_taxonomy = taxonomyName;
        String string = this.m_name = termName != null && termName.isEmpty() ? null : termName;
        if (this.m_name != null) {
            this.m_fqn = String.format("%s.%s", taxonomyName, termName);
            this.m_paths = termName.split("\\.");
        } else {
            this.m_fqn = taxonomyName;
            this.m_paths = new String[0];
        }
    }

    public String getFullyQualifiedName() {
        return this.m_fqn;
    }

    public String getName() {
        return this.m_name;
    }

    public String getShortName() {
        return this.m_paths[this.m_paths.length - 1];
    }

    public String getPath() {
        int lastIdx;
        if (this.m_name == null) {
            return "/";
        }
        int idx = this.m_fqn.indexOf(46);
        return idx == (lastIdx = this.m_fqn.lastIndexOf(46)) ? "/" : this.m_fqn.substring(idx, lastIdx).replaceAll("\\.", "/");
    }

    public TermPath getParent() {
        return new TermPath(this.m_taxonomy, this.m_name.substring(0, this.m_name.lastIndexOf(46)));
    }

    public String getTaxonomyName() {
        return this.m_taxonomy;
    }

    public String[] getPathSegments() {
        return this.m_paths;
    }
}

