/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.BaseResourceProvider;
import org.apache.atlas.catalog.CollectionRequest;
import org.apache.atlas.catalog.InstanceRequest;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceProvider;
import org.apache.atlas.catalog.Result;
import org.apache.atlas.catalog.TermPath;
import org.apache.atlas.catalog.TermResourceProvider;
import org.apache.atlas.catalog.definition.TaxonomyResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.exception.InvalidQueryException;
import org.apache.atlas.catalog.exception.ResourceAlreadyExistsException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.query.AtlasQuery;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyResourceProvider
extends BaseResourceProvider
implements ResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TaxonomyResourceProvider.class);
    public static final String DEFAULT_TAXONOMY_NAME = "Catalog";
    public static final String DEFAULT_TAXONOMY_DESCRIPTION = "Business Catalog";
    private final TermResourceProvider termResourceProvider;
    private static boolean taxonomyAutoInitializationChecked = false;

    public TaxonomyResourceProvider(AtlasTypeSystem typeSystem) {
        super(typeSystem, new TaxonomyResourceDefinition());
        this.termResourceProvider = new TermResourceProvider(typeSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getResourceById(Request request) throws ResourceNotFoundException {
        Class<TaxonomyResourceProvider> clazz = TaxonomyResourceProvider.class;
        synchronized (TaxonomyResourceProvider.class) {
            this.createDefaultTaxonomyIfNeeded();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.doGetResourceById(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        Class<TaxonomyResourceProvider> clazz = TaxonomyResourceProvider.class;
        synchronized (TaxonomyResourceProvider.class) {
            this.createDefaultTaxonomyIfNeeded();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.doGetResources(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createResource(Request request) throws InvalidPayloadException, ResourceAlreadyExistsException {
        this.resourceDefinition.validateCreatePayload(request);
        Class<TaxonomyResourceProvider> clazz = TaxonomyResourceProvider.class;
        synchronized (TaxonomyResourceProvider.class) {
            this.ensureTaxonomyDoesntExist(request);
            this.doCreateResource(request);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Collection<String> createResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        throw new UnsupportedOperationException("Creating multiple Taxonomies in a request is not currently supported");
    }

    @Override
    public void deleteResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        String taxonomyId = this.getResourceId(request);
        this.getTermResourceProvider().deleteChildren(taxonomyId, new TermPath((String)request.getProperty("name")));
        this.typeSystem.deleteEntity(this.resourceDefinition, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        AtlasQuery atlasQuery;
        this.resourceDefinition.validateUpdatePayload(request);
        try {
            atlasQuery = this.queryFactory.createTaxonomyQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Term query: " + e, e);
        }
        Class<TaxonomyResourceProvider> clazz = TaxonomyResourceProvider.class;
        synchronized (TaxonomyResourceProvider.class) {
            this.createDefaultTaxonomyIfNeeded();
            if (atlasQuery.execute(request.getUpdateProperties()).isEmpty()) {
                throw new ResourceNotFoundException(String.format("Taxonomy '%s' not found.", request.getQueryProperties().get("name")));
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private String getResourceId(Request request) throws ResourceNotFoundException {
        request.addAdditionalSelectProperties(Collections.singleton("id"));
        Result result = this.getResourceById(request);
        return String.valueOf(result.getPropertyMaps().iterator().next().get("id"));
    }

    private void ensureTaxonomyDoesntExist(Request request) throws ResourceAlreadyExistsException {
        try {
            this.doGetResourceById(request);
            throw new ResourceAlreadyExistsException(String.format("Taxonomy '%s' already exists.", request.getProperty("name")));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return;
        }
    }

    private Result doGetResourceById(Request request) throws ResourceNotFoundException {
        AtlasQuery atlasQuery;
        try {
            atlasQuery = this.queryFactory.createTaxonomyQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Taxonomy query: " + e, e);
        }
        Collection<Map<String, Object>> resultSet = atlasQuery.execute();
        if (resultSet.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Taxonomy '%s' not found.", request.getProperty(this.resourceDefinition.getIdPropertyName())));
        }
        return new Result(resultSet);
    }

    private Result doGetResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        AtlasQuery atlasQuery = this.queryFactory.createTaxonomyQuery(request);
        return new Result(atlasQuery.execute());
    }

    private void doCreateResource(Request request) throws ResourceAlreadyExistsException {
        this.typeSystem.createEntity(this.resourceDefinition, request);
        taxonomyAutoInitializationChecked = true;
    }

    private void createDefaultTaxonomyIfNeeded() {
        block7: {
            if (!this.autoInitializationChecked()) {
                try {
                    LOG.info("Checking if default taxonomy needs to be created.");
                    if (this.doGetResources(new CollectionRequest(null, null)).getPropertyMaps().isEmpty()) {
                        LOG.info("No taxonomies found - going to create default taxonomy.");
                        HashMap<String, Object> requestProperties = new HashMap<String, Object>();
                        String defaultTaxonomyName = DEFAULT_TAXONOMY_NAME;
                        try {
                            Configuration configuration = ApplicationProperties.get();
                            defaultTaxonomyName = configuration.getString("atlas.taxonomy.default.name", defaultTaxonomyName);
                        }
                        catch (AtlasException e) {
                            LOG.warn("Unable to read Atlas configuration, will use {} as default taxonomy name", (Object)defaultTaxonomyName, (Object)e);
                        }
                        requestProperties.put("name", defaultTaxonomyName);
                        requestProperties.put("description", DEFAULT_TAXONOMY_DESCRIPTION);
                        this.doCreateResource(new InstanceRequest(requestProperties));
                        LOG.info("Successfully created default taxonomy {}.", (Object)defaultTaxonomyName);
                        break block7;
                    }
                    taxonomyAutoInitializationChecked = true;
                    LOG.info("Some taxonomy exists, not creating default taxonomy");
                }
                catch (InvalidQueryException | ResourceNotFoundException e) {
                    LOG.error("Unable to query for existing taxonomies due to internal error.", (Throwable)e);
                }
                catch (ResourceAlreadyExistsException e) {
                    LOG.info("Attempted to create default taxonomy and it already exists.");
                }
            }
        }
    }

    protected boolean autoInitializationChecked() {
        return taxonomyAutoInitializationChecked;
    }

    protected TermResourceProvider getTermResourceProvider() {
        return this.termResourceProvider;
    }
}

