/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.catalog.Result;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;

public class JsonSerializer {
    public String serialize(Result result, UriInfo ui) {
        StringWriter json = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)json);
        writer.setIndent("    ");
        try {
            this.writeValue(writer, result.getPropertyMaps(), ui.getBaseUri().toASCIIString());
        }
        catch (IOException e) {
            throw new CatalogRuntimeException("Unable to write JSON response.", e);
        }
        return ((Object)json).toString();
    }

    private void writeValue(JsonWriter writer, Object value, String baseUrl) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof Map) {
            writer.beginObject();
            LinkedHashMap nonScalarMap = new LinkedHashMap();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val == null || !(val instanceof Collection) && !(val instanceof Map)) {
                    if (key.equals("href")) {
                        val = baseUrl + String.valueOf(val);
                    }
                    writer.name(key);
                    this.writeValue(writer, val, baseUrl);
                    continue;
                }
                nonScalarMap.put(key, val);
            }
            for (Map.Entry entry : nonScalarMap.entrySet()) {
                writer.name((String)entry.getKey());
                this.writeValue(writer, entry.getValue(), baseUrl);
            }
            writer.endObject();
        } else if (value instanceof Collection) {
            writer.beginArray();
            for (Object o : (Collection)value) {
                this.writeValue(writer, o, baseUrl);
            }
            writer.endArray();
        } else if (value instanceof Number) {
            writer.value((Number)value);
        } else if (value instanceof Boolean) {
            writer.value(((Boolean)value).booleanValue());
        } else {
            writer.value(String.valueOf(value));
        }
    }
}

