/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.BaseResourceProvider;
import org.apache.atlas.catalog.InstanceRequest;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceProvider;
import org.apache.atlas.catalog.Result;
import org.apache.atlas.catalog.TermPath;
import org.apache.atlas.catalog.TermResourceProvider;
import org.apache.atlas.catalog.definition.EntityTagResourceDefinition;
import org.apache.atlas.catalog.exception.CatalogRuntimeException;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.exception.InvalidQueryException;
import org.apache.atlas.catalog.exception.ResourceAlreadyExistsException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.query.AtlasQuery;

public class EntityTagResourceProvider
extends BaseResourceProvider
implements ResourceProvider {
    private TermResourceProvider termResourceProvider;

    public EntityTagResourceProvider(AtlasTypeSystem typeSystem) {
        super(typeSystem, new EntityTagResourceDefinition());
    }

    @Override
    public Result getResourceById(Request request) throws ResourceNotFoundException {
        AtlasQuery atlasQuery;
        try {
            atlasQuery = this.queryFactory.createEntityTagQuery(request);
        }
        catch (InvalidQueryException e) {
            throw new CatalogRuntimeException("Unable to compile internal Entity Tag query: " + e, e);
        }
        Collection<Map<String, Object>> results = atlasQuery.execute();
        if (results.isEmpty()) {
            throw new ResourceNotFoundException(String.format("Tag '%s' not found.", request.getProperty(this.resourceDefinition.getIdPropertyName())));
        }
        return new Result(results);
    }

    @Override
    public Result getResources(Request request) throws InvalidQueryException, ResourceNotFoundException {
        AtlasQuery atlasQuery = this.queryFactory.createEntityTagQuery(request);
        return new Result(atlasQuery.execute());
    }

    @Override
    public void createResource(Request request) throws InvalidPayloadException, ResourceAlreadyExistsException, ResourceNotFoundException {
        String entityId = String.valueOf(request.getQueryProperties().remove("id"));
        this.resourceDefinition.validateCreatePayload(request);
        Result termResult = this.getTermQueryResult((String)request.getProperty("name"));
        Map<String, Object> termProperties = termResult.getPropertyMaps().iterator().next();
        if (String.valueOf(termProperties.get("available_as_tag")).equals("false")) {
            throw new InvalidPayloadException("Attempted to tag an entity with a term which is not available to be tagged");
        }
        this.tagEntities(Collections.singleton(entityId), termProperties);
    }

    @Override
    public Collection<String> createResources(Request request) throws InvalidQueryException, ResourceNotFoundException, ResourceAlreadyExistsException {
        ArrayList<String> relativeUrls = new ArrayList<String>();
        AtlasQuery atlasQuery = this.queryFactory.createEntityQuery(request);
        ArrayList<String> guids = new ArrayList<String>();
        for (Map<String, Object> entityMap : atlasQuery.execute()) {
            guids.add(String.valueOf(entityMap.get("id")));
        }
        Collection tagMaps = (Collection)request.getProperty("tags");
        for (Map tagMap : tagMaps) {
            Result termResult = this.getTermQueryResult((String)tagMap.get("name"));
            relativeUrls.addAll(this.tagEntities(guids, termResult.getPropertyMaps().iterator().next()));
        }
        return relativeUrls;
    }

    @Override
    public void deleteResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        this.typeSystem.deleteTag((String)request.getProperty("id"), (String)request.getProperty("name"));
    }

    private Result getTermQueryResult(String termName) throws ResourceNotFoundException {
        InstanceRequest tagRequest = new InstanceRequest(Collections.singletonMap("termPath", new TermPath(termName)));
        tagRequest.addAdditionalSelectProperties(Collections.singleton("type"));
        return this.getTermResourceProvider().getResourceById(tagRequest);
    }

    private Collection<String> tagEntities(Collection<String> entityGuids, Map<String, Object> termProperties) throws ResourceAlreadyExistsException {
        ArrayList<String> relativeUrls = new ArrayList<String>();
        for (String guid : entityGuids) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String termName = String.valueOf(termProperties.get("name"));
            properties.put("name", termName);
            properties.put("description", termProperties.get("description"));
            this.typeSystem.createTraitInstance(guid, termName, properties);
            relativeUrls.add(String.format("v1/entities/%s/tags/%s", guid, termName));
        }
        return relativeUrls;
    }

    protected synchronized ResourceProvider getTermResourceProvider() {
        if (this.termResourceProvider == null) {
            this.termResourceProvider = new TermResourceProvider(this.typeSystem);
        }
        return this.termResourceProvider;
    }
}

