/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import org.apache.atlas.catalog.AtlasTypeSystem;
import org.apache.atlas.catalog.Request;
import org.apache.atlas.catalog.ResourceProvider;
import org.apache.atlas.catalog.definition.ResourceDefinition;
import org.apache.atlas.catalog.exception.InvalidPayloadException;
import org.apache.atlas.catalog.exception.ResourceNotFoundException;
import org.apache.atlas.catalog.query.QueryFactory;

public abstract class BaseResourceProvider
implements ResourceProvider {
    protected final AtlasTypeSystem typeSystem;
    protected QueryFactory queryFactory = new QueryFactory();
    protected final ResourceDefinition resourceDefinition;

    protected BaseResourceProvider(AtlasTypeSystem typeSystem, ResourceDefinition resourceDefinition) {
        this.typeSystem = typeSystem;
        this.resourceDefinition = resourceDefinition;
    }

    protected void setQueryFactory(QueryFactory factory) {
        this.queryFactory = factory;
    }

    @Override
    public void deleteResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        throw new InvalidPayloadException("Delete is not supported for this resource type");
    }

    @Override
    public void updateResourceById(Request request) throws ResourceNotFoundException, InvalidPayloadException {
        throw new InvalidPayloadException("Update is not supported for this resource type");
    }
}

