/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.catalog;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.atlas.catalog.Request;

public abstract class BaseRequest
implements Request {
    private final Map<String, Object> queryProperties = new HashMap<String, Object>();
    private final Map<String, Object> updateProperties = new HashMap<String, Object>();
    private final String queryString;
    private final Collection<String> additionalSelectProperties = new HashSet<String>();

    protected BaseRequest(Map<String, Object> queryProperties, String queryString) {
        this(queryProperties, queryString, null);
    }

    protected BaseRequest(Map<String, Object> queryProperties, String queryString, Map<String, Object> updateProperties) {
        if (queryProperties != null) {
            this.queryProperties.putAll(queryProperties);
        }
        if (updateProperties != null) {
            this.updateProperties.putAll(updateProperties);
        }
        this.queryString = queryString;
    }

    @Override
    public Map<String, Object> getQueryProperties() {
        return this.queryProperties;
    }

    @Override
    public Map<String, Object> getUpdateProperties() {
        return this.updateProperties;
    }

    @Override
    public <T> T getProperty(String name) {
        return (T)this.queryProperties.get(name);
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void addAdditionalSelectProperties(Collection<String> resultProperties) {
        this.additionalSelectProperties.addAll(resultProperties);
    }

    @Override
    public Collection<String> getAdditionalSelectProperties() {
        return this.additionalSelectProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRequest that = (BaseRequest)o;
        return this.queryProperties.equals(that.queryProperties) && this.updateProperties.equals(that.updateProperties) && this.additionalSelectProperties.equals(that.additionalSelectProperties) && this.queryString == null ? that.queryString == null : this.queryString.equals(that.queryString);
    }

    public int hashCode() {
        int result = this.queryProperties.hashCode();
        result = 31 * result + this.updateProperties.hashCode();
        result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
        result = 31 * result + this.additionalSelectProperties.hashCode();
        return result;
    }
}

