/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Set;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasTypeRegistry;

public class AtlasRelationshipAccessRequest
extends AtlasAccessRequest {
    private final AtlasTypeRegistry typeRegistry;
    private final String relationshipType;
    private final AtlasEntityHeader end1Entity;
    private final AtlasEntityHeader end2Entity;

    public AtlasRelationshipAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, String relationshipType, AtlasEntityHeader end1Entity, AtlasEntityHeader end2Entity) {
        this(typeRegistry, action, relationshipType, end1Entity, end2Entity, null, null);
    }

    public AtlasRelationshipAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, String relationshipType, AtlasEntityHeader end1Entity, AtlasEntityHeader end2Entity, String user, Set<String> userGroups) {
        super(action, user, userGroups);
        this.typeRegistry = typeRegistry;
        this.relationshipType = relationshipType;
        this.end1Entity = end1Entity;
        this.end2Entity = end2Entity;
    }

    public AtlasEntityHeader getEnd1Entity() {
        return this.end1Entity;
    }

    public AtlasEntityHeader getEnd2Entity() {
        return this.end2Entity;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public Set<String> getEnd1EntityTypeAndAllSuperTypes() {
        return super.getEntityTypeAndAllSuperTypes(this.end1Entity == null ? null : this.end1Entity.getTypeName(), this.typeRegistry);
    }

    public Set<String> getEnd1EntityClassifications() {
        return super.getClassificationNames(this.end1Entity);
    }

    public String getEnd1EntityId() {
        return super.getEntityId(this.end1Entity, this.typeRegistry);
    }

    public Set<String> getEnd2EntityTypeAndAllSuperTypes() {
        return super.getEntityTypeAndAllSuperTypes(this.end2Entity == null ? null : this.end2Entity.getTypeName(), this.typeRegistry);
    }

    public Set<String> getEnd2EntityClassifications() {
        return super.getClassificationNames(this.end2Entity);
    }

    public String getEnd2EntityId() {
        return super.getEntityId(this.end2Entity, this.typeRegistry);
    }

    public Set<String> getClassificationTypeAndAllSuperTypes(String classificationName) {
        return super.getClassificationTypeAndAllSuperTypes(classificationName, this.typeRegistry);
    }

    @Override
    public String toString() {
        return "AtlasRelationshipAccessRequest[relationshipType=" + this.relationshipType + ", end1Entity=" + this.end1Entity + ", end2Entity=" + this.end2Entity + ", action=" + (Object)((Object)this.getAction()) + ", accessTime=" + this.getAccessTime() + ", user=" + this.getUser() + ", userGroups=" + this.getUserGroups() + ", clientIPAddress=" + this.getClientIPAddress() + ", forwardedAddresses=" + this.getForwardedAddresses() + ", remoteIPAddress=" + this.getRemoteIPAddress() + "]";
    }
}

