/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasAuthorizerFactory;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AtlasAuthorizationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthorizationUtils.class);

    public static void verifyAccess(AtlasAdminAccessRequest request, Object ... errorMsgParams) throws AtlasBaseException {
        if (!AtlasAuthorizationUtils.isAccessAllowed(request)) {
            String message = errorMsgParams != null && errorMsgParams.length > 0 ? StringUtils.join((Object[])errorMsgParams) : "";
            throw new AtlasBaseException(AtlasErrorCode.UNAUTHORIZED_ACCESS, new String[]{request.getUser(), message});
        }
    }

    public static void verifyAccess(AtlasTypeAccessRequest request, Object ... errorMsgParams) throws AtlasBaseException {
        if (!AtlasAuthorizationUtils.isAccessAllowed(request)) {
            String message = errorMsgParams != null && errorMsgParams.length > 0 ? StringUtils.join((Object[])errorMsgParams) : "";
            throw new AtlasBaseException(AtlasErrorCode.UNAUTHORIZED_ACCESS, new String[]{request.getUser(), message});
        }
    }

    public static void verifyAccess(AtlasEntityAccessRequest request, Object ... errorMsgParams) throws AtlasBaseException {
        if (!AtlasAuthorizationUtils.isAccessAllowed(request)) {
            String message = errorMsgParams != null && errorMsgParams.length > 0 ? StringUtils.join((Object[])errorMsgParams) : "";
            throw new AtlasBaseException(AtlasErrorCode.UNAUTHORIZED_ACCESS, new String[]{request.getUser(), message});
        }
    }

    public static void verifyAccess(AtlasRelationshipAccessRequest request, Object ... errorMsgParams) throws AtlasBaseException {
        if (!AtlasAuthorizationUtils.isAccessAllowed(request)) {
            String message = errorMsgParams != null && errorMsgParams.length > 0 ? StringUtils.join((Object[])errorMsgParams) : "";
            throw new AtlasBaseException(AtlasErrorCode.UNAUTHORIZED_ACCESS, new String[]{request.getUser(), message});
        }
    }

    public static void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasBaseException {
        String userName = AtlasAuthorizationUtils.getCurrentUserName();
        if (StringUtils.isNotEmpty((String)userName)) {
            try {
                AtlasAuthorizer authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                request.setUser(userName, AtlasAuthorizationUtils.getCurrentUserGroups());
                request.setClientIPAddress(RequestContext.get().getClientIPAddress());
                authorizer.scrubSearchResults(request);
            }
            catch (AtlasAuthorizationException e) {
                LOG.error("Unable to obtain AtlasAuthorizer", (Throwable)e);
            }
        }
    }

    public static boolean isAccessAllowed(AtlasAdminAccessRequest request) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("isAccessAllowed");
        boolean ret = false;
        String userName = AtlasAuthorizationUtils.getCurrentUserName();
        if (StringUtils.isNotEmpty((String)userName)) {
            try {
                AtlasAuthorizer authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                request.setUser(userName, AtlasAuthorizationUtils.getCurrentUserGroups());
                request.setClientIPAddress(RequestContext.get().getClientIPAddress());
                ret = authorizer.isAccessAllowed(request);
            }
            catch (AtlasAuthorizationException e) {
                LOG.error("Unable to obtain AtlasAuthorizer", (Throwable)e);
            }
        } else {
            ret = true;
        }
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static boolean isAccessAllowed(AtlasEntityAccessRequest request) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("isAccessAllowed");
        boolean ret = false;
        String userName = AtlasAuthorizationUtils.getCurrentUserName();
        if (StringUtils.isNotEmpty((String)userName) && !RequestContext.get().isImportInProgress()) {
            try {
                AtlasAuthorizer authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                request.setUser(AtlasAuthorizationUtils.getCurrentUserName(), AtlasAuthorizationUtils.getCurrentUserGroups());
                request.setClientIPAddress(RequestContext.get().getClientIPAddress());
                ret = authorizer.isAccessAllowed(request);
            }
            catch (AtlasAuthorizationException e) {
                LOG.error("Unable to obtain AtlasAuthorizer", (Throwable)e);
            }
        } else {
            ret = true;
        }
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static boolean isAccessAllowed(AtlasTypeAccessRequest request) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("isAccessAllowed");
        boolean ret = false;
        String userName = AtlasAuthorizationUtils.getCurrentUserName();
        if (StringUtils.isNotEmpty((String)userName) && !RequestContext.get().isImportInProgress()) {
            try {
                AtlasAuthorizer authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                request.setUser(AtlasAuthorizationUtils.getCurrentUserName(), AtlasAuthorizationUtils.getCurrentUserGroups());
                request.setClientIPAddress(RequestContext.get().getClientIPAddress());
                ret = authorizer.isAccessAllowed(request);
            }
            catch (AtlasAuthorizationException e) {
                LOG.error("Unable to obtain AtlasAuthorizer", (Throwable)e);
            }
        } else {
            ret = true;
        }
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static boolean isAccessAllowed(AtlasRelationshipAccessRequest request) {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("isAccessAllowed");
        boolean ret = false;
        String userName = AtlasAuthorizationUtils.getCurrentUserName();
        if (StringUtils.isNotEmpty((String)userName) && !RequestContext.get().isImportInProgress()) {
            try {
                AtlasAuthorizer authorizer = AtlasAuthorizerFactory.getAtlasAuthorizer();
                request.setUser(AtlasAuthorizationUtils.getCurrentUserName(), AtlasAuthorizationUtils.getCurrentUserGroups());
                request.setClientIPAddress(RequestContext.get().getClientIPAddress());
                ret = authorizer.isAccessAllowed(request);
            }
            catch (AtlasAuthorizationException e) {
                LOG.error("Unable to obtain AtlasAuthorizer", (Throwable)e);
            }
        } else {
            ret = true;
        }
        RequestContext.get().endMetricRecord(metric);
        return ret;
    }

    public static String getRequestIpAddress(HttpServletRequest httpServletRequest) {
        String ret = "";
        try {
            InetAddress inetAddr = InetAddress.getByName(httpServletRequest.getRemoteAddr());
            ret = inetAddr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOG.error("Failed to retrieve client IP address", (Throwable)ex);
        }
        return ret;
    }

    public static String getCurrentUserName() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null ? auth.getName() : "";
    }

    public static Set<String> getCurrentUserGroups() {
        HashSet<String> ret = new HashSet<String>();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            for (GrantedAuthority c : auth.getAuthorities()) {
                ret.add(c.getAuthority());
            }
        }
        return ret;
    }
}

