/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Set;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasTypeRegistry;

public class AtlasEntityAccessRequest
extends AtlasAccessRequest {
    private final AtlasEntityHeader entity;
    private final String entityId;
    private final AtlasClassification classification;
    private final String attributeName;
    private final AtlasTypeRegistry typeRegistry;
    private final Set<String> entityClassifications;

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action) {
        this(typeRegistry, action, null, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity) {
        this(typeRegistry, action, entity, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification) {
        this(typeRegistry, action, entity, classification, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String attributeName) {
        this(typeRegistry, action, entity, null, attributeName, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, null, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, classification, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String attributeName, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, null, attributeName, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification, String attributeName, String userName, Set<String> userGroups) {
        super(action, userName, userGroups);
        this.entity = entity;
        this.entityId = super.getEntityId(entity, typeRegistry);
        this.classification = classification;
        this.attributeName = attributeName;
        this.typeRegistry = typeRegistry;
        this.entityClassifications = super.getClassificationNames(entity);
    }

    public AtlasEntityHeader getEntity() {
        return this.entity;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public AtlasClassification getClassification() {
        return this.classification;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getEntityType() {
        return this.entity == null ? "" : this.entity.getTypeName();
    }

    public Set<String> getEntityClassifications() {
        return this.entityClassifications;
    }

    public Set<String> getEntityTypeAndAllSuperTypes() {
        return super.getEntityTypeAndAllSuperTypes(this.entity == null ? null : this.entity.getTypeName(), this.typeRegistry);
    }

    public Set<String> getClassificationTypeAndAllSuperTypes(String classificationName) {
        return super.getClassificationTypeAndAllSuperTypes(classificationName, this.typeRegistry);
    }

    @Override
    public String toString() {
        return "AtlasEntityAccessRequest[entity=" + this.entity + ", classification=" + this.classification + ", attributeName=" + this.attributeName + ", action=" + (Object)((Object)this.getAction()) + ", accessTime=" + this.getAccessTime() + ", user=" + this.getUser() + ", userGroups=" + this.getUserGroups() + ", clientIPAddress=" + this.getClientIPAddress() + "]";
    }
}

