/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.simple.AtlasSimpleAuthzPolicy;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasSimpleAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasSimpleAuthorizer.class);
    private static final String WILDCARD_ASTERISK = "*";
    private AtlasSimpleAuthzPolicy authzPolicy;

    @Override
    public void init() {
        LOG.info("==> SimpleAtlasAuthorizer.init()");
        InputStream inputStream = null;
        try {
            inputStream = ApplicationProperties.getFileAsInputStream((Configuration)ApplicationProperties.get(), (String)"atlas.authorizer.simple.authz.policy.file", (String)"atlas-simple-authz-policy.json");
            this.authzPolicy = (AtlasSimpleAuthzPolicy)AtlasJson.fromJson((InputStream)inputStream, AtlasSimpleAuthzPolicy.class);
        }
        catch (IOException | AtlasException e) {
            LOG.error("SimpleAtlasAuthorizer.init(): initialization failed", e);
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        LOG.info("<== SimpleAtlasAuthorizer.init()");
    }

    @Override
    public void cleanUp() {
        LOG.info("==> SimpleAtlasAuthorizer.cleanUp()");
        this.authzPolicy = null;
        LOG.info("<== SimpleAtlasAuthorizer.cleanUp()");
    }

    @Override
    public boolean isAccessAllowed(AtlasAdminAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        boolean ret = false;
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> permissions = this.getAdminPermissionsForRole(role);
            if (permissions == null) continue;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            for (AtlasSimpleAuthzPolicy.AtlasAdminPermission permission : permissions) {
                if (!this.isMatch(action, permission.getPrivileges())) continue;
                ret = true;
                continue block0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(AtlasTypeAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        boolean ret = false;
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasTypePermission> permissions = this.getTypePermissionsForRole(role);
            if (permissions == null) continue;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            String typeCategory = request.getTypeDef() != null ? request.getTypeDef().getCategory().name() : null;
            String typeName = request.getTypeDef() != null ? request.getTypeDef().getName() : null;
            for (AtlasSimpleAuthzPolicy.AtlasTypePermission permission : permissions) {
                if (!this.isMatch(action, permission.getPrivileges()) || !this.isMatch(typeCategory, permission.getTypeCategories()) || !this.isMatch(typeName, permission.getTypeNames())) continue;
                ret = true;
                continue block0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(AtlasEntityAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        String action = request.getAction() != null ? request.getAction().getType() : null;
        Set<String> entityTypes = request.getEntityTypeAndAllSuperTypes();
        String entityId = request.getEntityId();
        String classification = request.getClassification() != null ? request.getClassification().getTypeName() : null;
        String attribute = request.getAttributeName();
        HashSet<String> entClsToAuthz = new HashSet<String>(request.getEntityClassifications());
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        boolean hasEntityAccess = false;
        boolean hasClassificationsAccess = false;
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> permissions = this.getEntityPermissionsForRole(role);
            if (permissions == null) continue;
            for (AtlasSimpleAuthzPolicy.AtlasEntityPermission permission : permissions) {
                if (!this.isMatchAny(entityTypes, permission.getEntityTypes()) || !this.isMatch(entityId, permission.getEntityIds()) || !this.isMatch(attribute, permission.getAttributes())) continue;
                if (!hasEntityAccess && this.isMatch(action, permission.getPrivileges()) && this.isMatch(classification, permission.getClassifications())) {
                    hasEntityAccess = true;
                }
                Iterator iter = entClsToAuthz.iterator();
                while (iter.hasNext()) {
                    String entityClassification = (String)iter.next();
                    if (!this.isMatchAny(request.getClassificationTypeAndAllSuperTypes(entityClassification), permission.getClassifications())) continue;
                    iter.remove();
                }
                hasClassificationsAccess = CollectionUtils.isEmpty(entClsToAuthz);
                if (!hasEntityAccess || !hasClassificationsAccess) continue;
                continue block0;
            }
        }
        boolean bl = ret = hasEntityAccess && hasClassificationsAccess;
        if (LOG.isDebugEnabled()) {
            if (!ret) {
                LOG.debug("hasEntityAccess={}; hasClassificationsAccess={}, classificationsWithNoAccess={}", new Object[]{hasEntityAccess, hasClassificationsAccess, entClsToAuthz});
            }
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    private Set<String> getRoles(String userName, Set<String> userGroups) {
        HashSet<String> ret = new HashSet<String>();
        if (this.authzPolicy != null) {
            List<String> userRoles;
            if (userName != null && this.authzPolicy.getUserRoles() != null && (userRoles = this.authzPolicy.getUserRoles().get(userName)) != null) {
                ret.addAll(userRoles);
            }
            if (userGroups != null && this.authzPolicy.getGroupRoles() != null) {
                for (String groupName : userGroups) {
                    List<String> groupRoles = this.authzPolicy.getGroupRoles().get(groupName);
                    if (groupRoles == null) continue;
                    ret.addAll(groupRoles);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRoles({}, {}): {}", new Object[]{userName, userGroups, ret});
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> getAdminPermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getAdminPermissions() : null;
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasTypePermission> getTypePermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasTypePermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getTypePermissions() : null;
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> getEntityPermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getEntityPermissions() : null;
        }
        return ret;
    }

    private boolean isMatch(String value, List<String> patterns) {
        boolean ret = false;
        if (value == null) {
            ret = true;
        }
        if (CollectionUtils.isNotEmpty(patterns)) {
            for (String pattern : patterns) {
                if (!this.isMatch(value, pattern)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && LOG.isDebugEnabled()) {
            LOG.debug("<== isMatch({}, {}): {}", new Object[]{value, patterns, ret});
        }
        return ret;
    }

    private boolean isMatchAny(Set<String> values, List<String> patterns) {
        boolean ret = false;
        if (CollectionUtils.isEmpty(values)) {
            ret = true;
        }
        if (CollectionUtils.isNotEmpty(patterns)) {
            for (String value : values) {
                if (!this.isMatch(value, patterns)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && LOG.isDebugEnabled()) {
            LOG.debug("<== isMatchAny({}, {}): {}", new Object[]{values, patterns, ret});
        }
        return ret;
    }

    private boolean isMatch(String value, String pattern) {
        boolean ret = value == null ? true : StringUtils.equalsIgnoreCase((String)value, (String)pattern) || value.matches(pattern);
        return ret;
    }
}

