/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Date;
import java.util.Set;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAccessRequest {
    private static Logger LOG = LoggerFactory.getLogger(AtlasAccessRequest.class);
    private final AtlasPrivilege action;
    private final Date accessTime;
    private String user = null;
    private Set<String> userGroups = null;
    private String clientIPAddress = null;

    protected AtlasAccessRequest(AtlasPrivilege action) {
        this(action, null, null, new Date(), null);
    }

    protected AtlasAccessRequest(AtlasPrivilege action, String user, Set<String> userGroups) {
        this(action, user, userGroups, new Date(), null);
    }

    protected AtlasAccessRequest(AtlasPrivilege action, String user, Set<String> userGroups, Date accessTime, String clientIPAddress) {
        this.action = action;
        this.user = user;
        this.userGroups = userGroups;
        this.accessTime = accessTime;
        this.clientIPAddress = clientIPAddress;
    }

    public AtlasPrivilege getAction() {
        return this.action;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUser(String user, Set<String> userGroups) {
        this.user = user;
        this.userGroups = userGroups;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public String toString() {
        return "AtlasAccessRequest[action=" + (Object)((Object)this.action) + ", accessTime=" + this.accessTime + ", user=" + this.user + ", userGroups=" + this.userGroups + ", clientIPAddress=" + this.clientIPAddress + "]";
    }
}

