/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.apache.atlas.authorize.simple.PolicyDef;
import org.apache.atlas.authorize.simple.SimpleAtlasAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyUtil {
    private static Logger LOG = LoggerFactory.getLogger(PolicyUtil.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();

    public Map<String, Map<AtlasResourceTypes, List<String>>> createPermissionMap(List<PolicyDef> policyDefList, AtlasActionTypes permissionType, SimpleAtlasAuthorizer.AtlasAccessorTypes principalType) {
        if (isDebugEnabled) {
            LOG.debug("==> PolicyUtil createPermissionMap\nCreating Permission Map for :: " + (Object)((Object)permissionType) + " & " + (Object)((Object)principalType));
        }
        HashMap<String, Map<AtlasResourceTypes, List<String>>> userReadMap = new HashMap<String, Map<AtlasResourceTypes, List<String>>>();
        for (PolicyDef policyDef : policyDefList) {
            LOG.info("Processing policy def : " + policyDef);
            Map<String, List<AtlasActionTypes>> principalMap = principalType.equals((Object)SimpleAtlasAuthorizer.AtlasAccessorTypes.USER) ? policyDef.getUsers() : policyDef.getGroups();
            for (Map.Entry<String, List<AtlasActionTypes>> e : principalMap.entrySet()) {
                if (!e.getValue().contains((Object)permissionType)) continue;
                String username = e.getKey();
                HashMap userResourceList = (HashMap)userReadMap.get(username);
                if (userResourceList == null) {
                    if (isDebugEnabled) {
                        LOG.debug("Resource list not found for " + username + ", creating it");
                    }
                    userResourceList = new HashMap();
                }
                for (Map.Entry<AtlasResourceTypes, List<String>> resourceTypeMap : policyDef.getResources().entrySet()) {
                    AtlasResourceTypes type = resourceTypeMap.getKey();
                    ArrayList resourceList = (ArrayList)userResourceList.get((Object)type);
                    if (resourceList == null) {
                        resourceList = new ArrayList();
                        resourceList.addAll(resourceTypeMap.getValue());
                    } else {
                        resourceList.removeAll((Collection)resourceTypeMap.getValue());
                        resourceList.addAll(resourceTypeMap.getValue());
                    }
                    userResourceList.put(type, resourceList);
                }
                userReadMap.put(username, userResourceList);
                LOG.info("userReadMap " + userReadMap);
            }
        }
        if (isDebugEnabled) {
            LOG.debug("Returning Map for " + (Object)((Object)principalType) + " :: " + userReadMap);
            LOG.debug("<== PolicyUtil createPermissionMap");
        }
        return userReadMap;
    }
}

