/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.util.HashSet;
import java.util.Set;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAuthorizationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthorizationUtils.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private static final String BASE_URL = "/api/atlas/";

    public static String getApi(String contextPath) {
        if (isDebugEnabled) {
            LOG.debug("==> getApi from " + contextPath);
        }
        if (contextPath.startsWith(BASE_URL)) {
            contextPath = contextPath.substring(BASE_URL.length());
        } else if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        String[] split = contextPath.split("/", 3);
        String api = split[0];
        if (split.length > 1) {
            return !api.equals("v1") ? api : String.format("v1/%s", split[1]);
        }
        return api;
    }

    public static AtlasActionTypes getAtlasAction(String method) {
        AtlasActionTypes action = null;
        switch (method.toUpperCase()) {
            case "POST": {
                action = AtlasActionTypes.CREATE;
                break;
            }
            case "GET": {
                action = AtlasActionTypes.READ;
                break;
            }
            case "PUT": {
                action = AtlasActionTypes.UPDATE;
                break;
            }
            case "DELETE": {
                action = AtlasActionTypes.DELETE;
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                LOG.debug("getAtlasAction(): Invalid HTTP method '" + method + "'");
            }
        }
        if (isDebugEnabled) {
            LOG.debug("<== AtlasAuthorizationFilter getAtlasAction HTTP Method " + method + " mapped to AtlasAction : " + (Object)((Object)action));
        }
        return action;
    }

    public static Set<AtlasResourceTypes> getAtlasResourceType(String contextPath) {
        String api;
        HashSet<AtlasResourceTypes> resourceTypes = new HashSet<AtlasResourceTypes>();
        if (isDebugEnabled) {
            LOG.debug("==> getAtlasResourceType  for " + contextPath);
        }
        if ((api = AtlasAuthorizationUtils.getApi(contextPath)).startsWith("types")) {
            resourceTypes.add(AtlasResourceTypes.TYPE);
        } else if (api.startsWith("admin") && (contextPath.contains("/session") || contextPath.contains("/version"))) {
            resourceTypes.add(AtlasResourceTypes.UNKNOWN);
        } else if (api.startsWith("discovery") && contextPath.contains("/gremlin") || api.startsWith("admin") || api.startsWith("graph")) {
            resourceTypes.add(AtlasResourceTypes.OPERATION);
        } else if (api.startsWith("entities") || api.startsWith("lineage") || api.startsWith("discovery")) {
            resourceTypes.add(AtlasResourceTypes.ENTITY);
        } else if (api.startsWith("v1/taxonomies")) {
            resourceTypes.add(AtlasResourceTypes.TAXONOMY);
            resourceTypes.add(AtlasResourceTypes.ENTITY);
            if (contextPath.contains("/terms")) {
                resourceTypes.add(AtlasResourceTypes.TERM);
            }
        } else if (api.startsWith("v1/entities")) {
            resourceTypes.add(AtlasResourceTypes.ENTITY);
        } else {
            LOG.error("Unable to find Atlas Resource corresponding to : " + api + "\nSetting " + AtlasResourceTypes.UNKNOWN.name());
            resourceTypes.add(AtlasResourceTypes.UNKNOWN);
        }
        if (isDebugEnabled) {
            LOG.debug("<== Returning AtlasResources " + resourceTypes + " for api " + api);
        }
        return resourceTypes;
    }
}

