/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Date;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.apache.atlas.authorize.simple.AtlasAuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAccessRequest {
    private static Logger LOG = LoggerFactory.getLogger(AtlasAccessRequest.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private Set<AtlasResourceTypes> resourceType = null;
    private String resource = null;
    private AtlasActionTypes action = null;
    private String user = null;
    private Set<String> userGroups = null;
    private Date accessTime = null;
    private String clientIPAddress = null;

    public AtlasAccessRequest(HttpServletRequest request, String user, Set<String> userGroups) {
        this(AtlasAuthorizationUtils.getAtlasResourceType(request.getServletPath()), "*", AtlasAuthorizationUtils.getAtlasAction(request.getMethod()), user, userGroups);
    }

    public AtlasAccessRequest(Set<AtlasResourceTypes> resourceType, String resource, AtlasActionTypes action, String user, Set<String> userGroups) {
        if (isDebugEnabled) {
            LOG.debug("==> AtlasAccessRequestImpl-- Initializing AtlasAccessRequest");
        }
        this.setResource(resource);
        this.setAction(action);
        this.setUser(user);
        this.setUserGroups(userGroups);
        this.setResourceType(resourceType);
        this.setAccessTime(null);
        this.setClientIPAddress(null);
    }

    public Set<AtlasResourceTypes> getResourceTypes() {
        return this.resourceType;
    }

    public void setResourceType(Set<AtlasResourceTypes> resourceType) {
        this.resourceType = resourceType;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public AtlasActionTypes getAction() {
        return this.action;
    }

    public void setAction(AtlasActionTypes action) {
        this.action = action;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUserGroups(Set<String> userGroups) {
        this.userGroups = userGroups;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public String toString() {
        return "AtlasAccessRequest [resourceType=" + this.resourceType + ", resource=" + this.resource + ", action=" + (Object)((Object)this.action) + ", user=" + this.user + ", userGroups=" + this.userGroups + ", accessTime=" + this.accessTime + ", clientIPAddress=" + this.clientIPAddress + "]";
    }
}

