/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasActionTypes;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasResourceTypes;
import org.apache.atlas.authorize.simple.FileReaderUtil;
import org.apache.atlas.authorize.simple.PolicyDef;
import org.apache.atlas.authorize.simple.PolicyParser;
import org.apache.atlas.authorize.simple.PolicyUtil;
import org.apache.atlas.utils.PropertiesUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleAtlasAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAtlasAuthorizer.class);
    private boolean isDebugEnabled = LOG.isDebugEnabled();
    private static final String WILDCARD_ASTERISK = "*";
    private static final String WILDCARDS = "*?";
    private boolean optIgnoreCase = false;
    private Map<String, Map<AtlasResourceTypes, List<String>>> userReadMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> userWriteMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> userUpdateMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> userDeleteMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> groupReadMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> groupWriteMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> groupUpdateMap = null;
    private Map<String, Map<AtlasResourceTypes, List<String>>> groupDeleteMap = null;

    @Override
    public void init() {
        block6: {
            if (this.isDebugEnabled) {
                LOG.debug("==> SimpleAtlasAuthorizer init");
            }
            try {
                PolicyUtil util = new PolicyUtil();
                PolicyParser parser = new PolicyParser();
                this.optIgnoreCase = Boolean.valueOf(PropertiesUtil.getProperty((String)"optIgnoreCase", (String)"false"));
                if (this.isDebugEnabled) {
                    LOG.debug("Read from PropertiesUtil --> optIgnoreCase :: " + this.optIgnoreCase);
                }
                Configuration configuration = ApplicationProperties.get();
                String policyStorePath = configuration.getString("atlas.auth.policy.file", System.getProperty("atlas.conf") + "/policy-store.txt");
                if (this.isDebugEnabled) {
                    LOG.debug("Loading Apache Atlas policies from : " + policyStorePath);
                }
                List<String> policies = FileReaderUtil.readFile(policyStorePath);
                List<PolicyDef> policyDef = parser.parsePolicies(policies);
                this.userReadMap = util.createPermissionMap(policyDef, AtlasActionTypes.READ, AtlasAccessorTypes.USER);
                this.userWriteMap = util.createPermissionMap(policyDef, AtlasActionTypes.CREATE, AtlasAccessorTypes.USER);
                this.userUpdateMap = util.createPermissionMap(policyDef, AtlasActionTypes.UPDATE, AtlasAccessorTypes.USER);
                this.userDeleteMap = util.createPermissionMap(policyDef, AtlasActionTypes.DELETE, AtlasAccessorTypes.USER);
                this.groupReadMap = util.createPermissionMap(policyDef, AtlasActionTypes.READ, AtlasAccessorTypes.GROUP);
                this.groupWriteMap = util.createPermissionMap(policyDef, AtlasActionTypes.CREATE, AtlasAccessorTypes.GROUP);
                this.groupUpdateMap = util.createPermissionMap(policyDef, AtlasActionTypes.UPDATE, AtlasAccessorTypes.GROUP);
                this.groupDeleteMap = util.createPermissionMap(policyDef, AtlasActionTypes.DELETE, AtlasAccessorTypes.GROUP);
                if (this.isDebugEnabled) {
                    LOG.debug("\n\nUserReadMap :: " + this.userReadMap + "\nGroupReadMap :: " + this.groupReadMap);
                    LOG.debug("\n\nUserWriteMap :: " + this.userWriteMap + "\nGroupWriteMap :: " + this.groupWriteMap);
                    LOG.debug("\n\nUserUpdateMap :: " + this.userUpdateMap + "\nGroupUpdateMap :: " + this.groupUpdateMap);
                    LOG.debug("\n\nUserDeleteMap :: " + this.userDeleteMap + "\nGroupDeleteMap :: " + this.groupDeleteMap);
                }
            }
            catch (IOException | AtlasException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error("SimpleAtlasAuthorizer could not be initialized properly due to : ", e);
            }
        }
    }

    @Override
    public boolean isAccessAllowed(AtlasAccessRequest request) throws AtlasAuthorizationException {
        boolean isGroup;
        if (this.isDebugEnabled) {
            LOG.debug("==> SimpleAtlasAuthorizer isAccessAllowed");
            LOG.debug("isAccessAllowd(" + request + ")");
        }
        String user = request.getUser();
        Set<String> groups = request.getUserGroups();
        AtlasActionTypes action = request.getAction();
        String resource = request.getResource();
        Set<AtlasResourceTypes> resourceTypes = request.getResourceTypes();
        if (this.isDebugEnabled) {
            LOG.debug("Checking for :: \nUser :: " + user + "\nGroups :: " + groups + "\nAction :: " + (Object)((Object)action) + "\nResource :: " + resource);
        }
        boolean isAccessAllowed = false;
        boolean isUser = user != null;
        boolean bl = isGroup = groups != null;
        if (!isUser && !isGroup || action == null || resource == null) {
            if (this.isDebugEnabled) {
                LOG.debug("Please check the formation AtlasAccessRequest.");
            }
            return isAccessAllowed;
        }
        if (this.isDebugEnabled) {
            LOG.debug("checkAccess for Operation :: " + (Object)((Object)action) + " on Resource " + resourceTypes + ":" + resource);
        }
        switch (action) {
            case READ: {
                isAccessAllowed = this.checkAccess(user, resourceTypes, resource, this.userReadMap);
                isAccessAllowed = !isAccessAllowed ? this.checkAccessForGroups(groups, resourceTypes, resource, this.groupReadMap) : isAccessAllowed;
                break;
            }
            case CREATE: {
                isAccessAllowed = this.checkAccess(user, resourceTypes, resource, this.userWriteMap);
                isAccessAllowed = !isAccessAllowed ? this.checkAccessForGroups(groups, resourceTypes, resource, this.groupWriteMap) : isAccessAllowed;
                break;
            }
            case UPDATE: {
                isAccessAllowed = this.checkAccess(user, resourceTypes, resource, this.userUpdateMap);
                isAccessAllowed = !isAccessAllowed ? this.checkAccessForGroups(groups, resourceTypes, resource, this.groupUpdateMap) : isAccessAllowed;
                break;
            }
            case DELETE: {
                isAccessAllowed = this.checkAccess(user, resourceTypes, resource, this.userDeleteMap);
                isAccessAllowed = !isAccessAllowed ? this.checkAccessForGroups(groups, resourceTypes, resource, this.groupDeleteMap) : isAccessAllowed;
                break;
            }
            default: {
                if (this.isDebugEnabled) {
                    LOG.debug("Invalid Action " + (Object)((Object)action) + "\nRaising AtlasAuthorizationException!!!");
                }
                throw new AtlasAuthorizationException("Invalid Action :: " + (Object)((Object)action));
            }
        }
        if (this.isDebugEnabled) {
            LOG.debug("<== SimpleAtlasAuthorizer isAccessAllowed = " + isAccessAllowed);
        }
        return isAccessAllowed;
    }

    private boolean checkAccess(String accessor, Set<AtlasResourceTypes> resourceTypes, String resource, Map<String, Map<AtlasResourceTypes, List<String>>> map) {
        if (this.isDebugEnabled) {
            LOG.debug("==> SimpleAtlasAuthorizer checkAccess");
            LOG.debug("Now checking access for accessor : " + accessor + "\nResource Types : " + resourceTypes + "\nResource : " + resource + "\nMap : " + map);
        }
        boolean result = true;
        Map<AtlasResourceTypes, List<String>> rescMap = map.get(accessor);
        if (rescMap != null) {
            for (AtlasResourceTypes resourceType : resourceTypes) {
                List<String> accessList = rescMap.get((Object)resourceType);
                if (this.isDebugEnabled) {
                    LOG.debug("\nChecking for resource : " + resource + " in list : " + accessList + "\n");
                }
                if (accessList != null) {
                    result = result && this.isMatch(resource, accessList);
                    continue;
                }
                result = false;
            }
        } else {
            result = false;
            if (this.isDebugEnabled) {
                LOG.debug("Key " + accessor + " missing. Returning with result : " + result);
            }
        }
        if (this.isDebugEnabled) {
            LOG.debug("Check for " + accessor + " :: " + result);
            LOG.debug("<== SimpleAtlasAuthorizer checkAccess");
        }
        return result;
    }

    private boolean checkAccessForGroups(Set<String> groups, Set<AtlasResourceTypes> resourceType, String resource, Map<String, Map<AtlasResourceTypes, List<String>>> map) {
        String group;
        boolean isAccessAllowed = false;
        if (this.isDebugEnabled) {
            LOG.debug("==> SimpleAtlasAuthorizer checkAccessForGroups");
        }
        Iterator<String> i$ = groups.iterator();
        while (i$.hasNext() && !(isAccessAllowed = this.checkAccess(group = i$.next(), resourceType, resource, map))) {
        }
        if (this.isDebugEnabled) {
            LOG.debug("<== SimpleAtlasAuthorizer checkAccessForGroups");
        }
        return isAccessAllowed;
    }

    private boolean resourceMatchHelper(List<String> policyResource) {
        boolean isMatchAny = false;
        if (this.isDebugEnabled) {
            LOG.debug("==> SimpleAtlasAuthorizer resourceMatchHelper");
        }
        boolean optWildCard = true;
        ArrayList<String> policyValues = new ArrayList<String>();
        if (policyResource != null) {
            boolean isWildCardPresent = !optWildCard;
            for (String policyValue : policyResource) {
                if (StringUtils.isEmpty((String)policyValue)) continue;
                if (StringUtils.containsOnly((String)policyValue, (String)WILDCARD_ASTERISK)) {
                    isMatchAny = true;
                } else if (!isWildCardPresent && StringUtils.containsAny((String)policyValue, (String)WILDCARDS)) {
                    isWildCardPresent = true;
                }
                policyValues.add(policyValue);
            }
            optWildCard = optWildCard && isWildCardPresent;
        } else {
            isMatchAny = false;
        }
        if (this.isDebugEnabled) {
            LOG.debug("<== SimpleAtlasAuthorizer resourceMatchHelper");
        }
        return isMatchAny;
    }

    private boolean isMatch(String resource, List<String> policyValues) {
        if (this.isDebugEnabled) {
            LOG.debug("==> SimpleAtlasAuthorizer isMatch");
        }
        boolean isMatchAny = this.resourceMatchHelper(policyValues);
        boolean isMatch = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        if (allValuesRequested || isMatchAny) {
            isMatch = isMatchAny;
        } else {
            for (String policyValue : policyValues) {
                if (policyValue.contains(WILDCARD_ASTERISK)) {
                    isMatch = this.optIgnoreCase ? FilenameUtils.wildcardMatch((String)resource, (String)policyValue, (IOCase)IOCase.INSENSITIVE) : FilenameUtils.wildcardMatch((String)resource, (String)policyValue, (IOCase)IOCase.SENSITIVE);
                } else {
                    boolean bl = isMatch = this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
                }
                if (!isMatch) continue;
                break;
            }
        }
        if (!isMatch && this.isDebugEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug("AtlasDefaultResourceMatcher.isMatch returns FALSE, (resource=" + resource + ", policyValues=" + sb.toString() + ")");
        }
        if (this.isDebugEnabled) {
            LOG.debug("<== SimpleAtlasAuthorizer isMatch(" + resource + "): " + isMatch);
        }
        return isMatch;
    }

    private boolean isAllValuesRequested(String resource) {
        boolean result = StringUtils.isEmpty((String)resource) || WILDCARD_ASTERISK.equals(resource);
        return result;
    }

    @Override
    public void cleanUp() {
        if (this.isDebugEnabled) {
            LOG.debug("==> +SimpleAtlasAuthorizer cleanUp");
        }
        this.userReadMap = null;
        this.userWriteMap = null;
        this.userUpdateMap = null;
        this.userDeleteMap = null;
        this.groupReadMap = null;
        this.groupWriteMap = null;
        this.groupUpdateMap = null;
        this.groupDeleteMap = null;
        if (this.isDebugEnabled) {
            LOG.debug("<== +SimpleAtlasAuthorizer cleanUp");
        }
    }

    @VisibleForTesting
    public void setResourcesForTesting(Map<String, Map<AtlasResourceTypes, List<String>>> userMap, Map<String, Map<AtlasResourceTypes, List<String>>> groupMap, AtlasActionTypes actionTypes) {
        switch (actionTypes) {
            case READ: {
                this.userReadMap = userMap;
                this.groupReadMap = groupMap;
                break;
            }
            case CREATE: {
                this.userWriteMap = userMap;
                this.groupWriteMap = groupMap;
                break;
            }
            case UPDATE: {
                this.userUpdateMap = userMap;
                this.groupUpdateMap = groupMap;
                break;
            }
            case DELETE: {
                this.userDeleteMap = userMap;
                this.groupDeleteMap = groupMap;
                break;
            }
            default: {
                if (!this.isDebugEnabled) break;
                LOG.debug("No such action available");
            }
        }
    }

    public static enum AtlasAccessorTypes {
        USER,
        GROUP;

    }
}

