/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAuthorizerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthorizerFactory.class);
    private static final String SIMPLE_AUTHORIZER = "org.apache.atlas.authorize.simple.SimpleAtlasAuthorizer";
    private static final String RANGER_AUTHORIZER = "org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer";
    private static volatile AtlasAuthorizer INSTANCE = null;
    private static boolean isDebugEnabled = LOG.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtlasAuthorizer getAtlasAuthorizer() throws AtlasAuthorizationException {
        Configuration configuration;
        block13: {
            configuration = null;
            try {
                configuration = ApplicationProperties.get();
            }
            catch (AtlasException e) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error("Exception while fetching configuration. ", (Throwable)e);
            }
        }
        AtlasAuthorizer ret = INSTANCE;
        if (ret != null) return ret;
        Class<AtlasAuthorizerFactory> clazz = AtlasAuthorizerFactory.class;
        synchronized (AtlasAuthorizerFactory.class) {
            String authorizerClass;
            if (INSTANCE != null) return ret;
            String string = authorizerClass = configuration != null ? configuration.getString("atlas.authorizer.impl") : "SIMPLE";
            if (StringUtils.isNotEmpty((String)authorizerClass)) {
                if (StringUtils.equalsIgnoreCase((String)authorizerClass, (String)"SIMPLE")) {
                    authorizerClass = SIMPLE_AUTHORIZER;
                } else if (StringUtils.equalsIgnoreCase((String)authorizerClass, (String)"RANGER")) {
                    authorizerClass = RANGER_AUTHORIZER;
                }
            } else {
                authorizerClass = SIMPLE_AUTHORIZER;
            }
            if (isDebugEnabled) {
                LOG.debug("Initializing Authorizer :: " + authorizerClass);
            }
            try {
                Class<?> authorizerMetaObject = Class.forName(authorizerClass);
                if (authorizerMetaObject == null) return INSTANCE;
                INSTANCE = (AtlasAuthorizer)authorizerMetaObject.newInstance();
                return INSTANCE;
            }
            catch (Exception e) {
                LOG.error("Error while creating authorizer of type '" + authorizerClass + "'", (Throwable)e);
                throw new AtlasAuthorizationException("Error while creating authorizer of type '" + authorizerClass + "'", e);
            }
        }
    }
}

