/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.util;

import com.google.protobuf.ProtocolMessageEnum;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.flight.sql.util.AdhocTestOption;
import org.apache.arrow.flight.sql.util.SqlInfoOptionsUtils;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class SqlInfoOptionsUtilsBitmaskParsingTest {
    @Parameterized.Parameter
    public long bitmask;
    @Parameterized.Parameter(value=1)
    public Set<AdhocTestOption> expectedOptions;
    @Rule
    public final ErrorCollector collector = new ErrorCollector();

    @Parameterized.Parameters
    public static List<Object[]> provideParameters() {
        return Arrays.asList({0L, EnumSet.noneOf(AdhocTestOption.class)}, {1L, EnumSet.of(AdhocTestOption.OPTION_A)}, {2L, EnumSet.of(AdhocTestOption.OPTION_B)}, {3L, EnumSet.of(AdhocTestOption.OPTION_A, AdhocTestOption.OPTION_B)}, {4L, EnumSet.of(AdhocTestOption.OPTION_C)}, {5L, EnumSet.of(AdhocTestOption.OPTION_A, AdhocTestOption.OPTION_C)}, {6L, EnumSet.of(AdhocTestOption.OPTION_B, AdhocTestOption.OPTION_C)}, {7L, EnumSet.allOf(AdhocTestOption.class)});
    }

    @Test
    public void testShouldFilterOutEnumsBasedOnBitmask() {
        Set actualOptions = Arrays.stream(AdhocTestOption.values()).filter(enumInstance -> SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)enumInstance, (long)this.bitmask)).collect(Collectors.toCollection(() -> EnumSet.noneOf(AdhocTestOption.class)));
        this.collector.checkThat((Object)actualOptions, CoreMatchers.is(this.expectedOptions));
    }
}

