/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.util;

import com.google.protobuf.ProtocolMessageEnum;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.flight.sql.util.AdhocTestOption;
import org.apache.arrow.flight.sql.util.SqlInfoOptionsUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public final class SqlInfoOptionsUtilsBitmaskParsingTest {
    public static List<Object[]> provideParameters() {
        return Arrays.asList({0L, EnumSet.noneOf(AdhocTestOption.class)}, {1L, EnumSet.of(AdhocTestOption.OPTION_A)}, {2L, EnumSet.of(AdhocTestOption.OPTION_B)}, {3L, EnumSet.of(AdhocTestOption.OPTION_A, AdhocTestOption.OPTION_B)}, {4L, EnumSet.of(AdhocTestOption.OPTION_C)}, {5L, EnumSet.of(AdhocTestOption.OPTION_A, AdhocTestOption.OPTION_C)}, {6L, EnumSet.of(AdhocTestOption.OPTION_B, AdhocTestOption.OPTION_C)}, {7L, EnumSet.allOf(AdhocTestOption.class)});
    }

    @ParameterizedTest
    @MethodSource(value={"provideParameters"})
    public void testShouldFilterOutEnumsBasedOnBitmask(long bitmask, Set<AdhocTestOption> expectedOptions) {
        Set actualOptions = Arrays.stream(AdhocTestOption.values()).filter(enumInstance -> SqlInfoOptionsUtils.doesBitmaskTranslateToEnum((ProtocolMessageEnum)enumInstance, (long)bitmask)).collect(Collectors.toCollection(() -> EnumSet.noneOf(AdhocTestOption.class)));
        Assertions.assertEquals((Object)actualOptions, expectedOptions);
    }
}

