/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.util.Text;

public class FlightStreamUtils {
    public static List<List<String>> getResults(FlightStream stream) {
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        while (stream.next()) {
            VectorSchemaRoot root = stream.getRoot();
            try {
                long rowCount = root.getRowCount();
                int i = 0;
                while ((long)i < rowCount) {
                    results.add(new ArrayList());
                    ++i;
                }
                root.getSchema().getFields().forEach(field -> {
                    block25: {
                        try (FieldVector fieldVector = root.getVector(field.getName());){
                            if (fieldVector instanceof VarCharVector) {
                                VarCharVector varcharVector = (VarCharVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Text data = varcharVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : data.toString());
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof IntVector) {
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = fieldVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof VarBinaryVector) {
                                VarBinaryVector varbinaryVector = (VarBinaryVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    String output;
                                    byte[] data = varbinaryVector.getObject(rowIndex);
                                    try {
                                        output = Objects.isNull(data) ? null : MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(data)))).toJson();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Failed to deserialize schema", e);
                                    }
                                    ((List)results.get(rowIndex)).add(output);
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof DenseUnionVector) {
                                DenseUnionVector denseUnionVector = (DenseUnionVector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = denseUnionVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof ListVector) {
                                for (int i = 0; i < fieldVector.getValueCount(); ++i) {
                                    if (fieldVector.isNull(i)) continue;
                                    List elements = ((ListVector)fieldVector).getObject(i);
                                    ArrayList<String> values = new ArrayList<String>();
                                    for (Text element : elements) {
                                        values.add(element.toString());
                                    }
                                    ((List)results.get(i)).add(((Object)values).toString());
                                }
                                break block25;
                            }
                            if (fieldVector instanceof UInt4Vector) {
                                UInt4Vector uInt4Vector = (UInt4Vector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Integer data = uInt4Vector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof UInt1Vector) {
                                UInt1Vector uInt1Vector = (UInt1Vector)fieldVector;
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Byte data = uInt1Vector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            if (fieldVector instanceof BitVector) {
                                int rowIndex = 0;
                                while ((long)rowIndex < rowCount) {
                                    Object data = fieldVector.getObject(rowIndex);
                                    ((List)results.get(rowIndex)).add(Objects.isNull(data) ? null : Objects.toString(data));
                                    ++rowIndex;
                                }
                                break block25;
                            }
                            throw new UnsupportedOperationException("Not yet implemented");
                        }
                    }
                });
            }
            finally {
                if (root == null) continue;
                root.close();
            }
        }
        return results;
    }
}

